package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.remote.internal;

import com.biz.crm.common.pay.support.cpcn.base.common.http.HttpData;
import com.biz.crm.common.pay.support.cpcn.base.common.http.NameValuePair;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnNoticeType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.configuration.CpcnProperties;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.remote.RemoteStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.vo.NoticeInfo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

/**
 * 4668-白名单开通/注销通知
 * <pre>
 *   机构系统发起 4665白名单开通/注销请求后，后续如果白名单状态变更为 20-启用或者 30-时效，
 *   支付平台会向机构系统在上线申请时提供的后台通知地址发送该笔白名单状态变更通知。
 *   机构系统收到该通知后需要给支付平台返回特定的响应，
 *   如果支付平台在 5 秒内未收到机构系统返回的通知响应或接收到的响应内容与规定内容不符，
 *   支付平台会认为机构系统未成功收到该通知，这时支付平台会向机构系统补发通知，最多补发两次，共发三次。
 * </pre>
 * @author dy
 * @date 2022/06/28
 */
@Slf4j
@Component
public class Remote4668Strategy implements RemoteStrategy {

  @Autowired
  private CpcnProperties cpcnProperties;
  @Autowired
  private CloseableHttpClient client;

  @Override
  public String getCode() {
    return CpcnNoticeType.NOTICE_4668.getCode();
  }

  @Override
  @Async("defaultRemoteNoticeExecutor")
  public void handler(NoticeInfo info) {
    if (ArrayUtils.isNotEmpty(cpcnProperties.getRemoteUrl())) {
      NameValuePair message = new NameValuePair("message", info.getMessage());
      NameValuePair signature = new NameValuePair("signature", info.getSignature());
      List<NameValuePair> params = Lists.newArrayList(message, signature);
      String[] urls = cpcnProperties.getRemoteUrl();
      for (String remoteUrl : urls) {
        try {
          String response = execute(remoteUrl, params);
          log.info("调用应用接口 :'{}',返回结果为:'{}'", remoteUrl, response);
        } catch (Exception e) {
          log.error(e.getMessage(), e);
          continue;
        }
      }
    } else {
      log.info("未配置转发地址，4658响应请求未转发");
    }
  }

  /**
   * 执行回调信息通知
   *
   * @param uri
   * @param list
   * @return
   */
  private String execute(String uri, List<NameValuePair> list) {
    HttpData httpData = new HttpData(list, StandardCharsets.UTF_8.name());
    String request = httpData.getData();
    HttpPost httpPost = new HttpPost(uri);
    BasicHeader basicHeader = new BasicHeader("Content-Type", "application/x-www-form-urlencoded");
    httpPost.addHeader(basicHeader);
    String response = null;
    HttpEntity httpEntity = null;
    try {
      StringEntity stringEntity = new StringEntity(request, StandardCharsets.UTF_8);
      httpPost.setEntity(stringEntity);
      CloseableHttpResponse closeableHttpResponse = client.execute(httpPost);
      httpEntity = closeableHttpResponse.getEntity();
      Validate.notNull(httpEntity, "httpclient请求返回为空，请检查请求地址！");
      response = EntityUtils.toString(httpEntity, StandardCharsets.UTF_8);
    } catch (IOException e) {
      log.error("httpclient 请求错误", e);
      throw new RuntimeException(e);
    }
    return response;
  }
}
