package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.AbstractTxStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4613Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4613Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 4613-绑卡确认
 *
 * <pre>
 *    4613 接口是绑卡确认接口，该接口配合 4611-绑卡接口使用，主要完成银行卡绑定的验证环节。
 *    机构系统通过该接口将用户提交的短信验证码或打款金额发送到支付平台，
 *    支付平台收到请求后立即处理，并将处理结果实时返回给机构系统。
 *
 *    该接口请求中包含机构编号、原业务流水号、验证方式等必传信息。
 *    短信验证码、打款金额等根据实际业务需求选择填写，具体参考下文:“报文结构”中字段描述。
 *
 *    说明:如果是个人账户通过短信验证方式进行绑卡确认，每个短信验证码默认只允许验证一次，
 *    一次验证失败后需重新获取验证码，也可以在上线时通过中金支付业务经理申请配置多次验证，
 *    即开通后每个短信验证码最多可以验证三次，第三次验证失败时需要重新获取验证码;短信超时时间为十分钟，
 *    十分钟后需重新获取验证码。如果是企业账户通过小额打款方式进行绑卡确认，
 *    一次打款可最多进行3次打款验证，验证有效期为自申请之日起 3个自然日内。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx4613Strategy extends AbstractTxStrategy<Tx4613Request, Tx4613Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_4613_REQUEST.getCode();
  }

  @Override
  public Class<Tx4613Response> getResponse() {
    return Tx4613Response.class;
  }
}
