package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.AbstractTxStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4666Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4666Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 4666-白名单开通/注销记录查询
 *
 * <pre>
 *     机构系统通过该接口可以对白名单开通/注销交易(4665-白名单开通/注销)进行查询，
 *     请求报文中包含机构编号、交易流水号必传信息，支付平台返 回该笔交易的白名单状态、审核状态等相关信息。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx4666Strategy extends AbstractTxStrategy<Tx4666Request, Tx4666Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_4666_REQUEST.getCode();
  }

  @Override
  public Class<Tx4666Response> getResponse() {
    return Tx4666Response.class;
  }
}
