package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.AbstractTxStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4693Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4693Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 4693-绑定银行账户查询
 *
 * 机构系统使用该接口可以对某个用户的银行卡绑定情况进行查询，支付平
 * 台返回该用户绑定的银行卡账户列表，列表中包含银行账户绑定流水号、开户行、
 * 账户类型、银行账户名称等信息。
 *
 * @author hefan
 * @date 2022/08/22
 */
@Component
@Slf4j
public class Tx4693Strategy extends AbstractTxStrategy<Tx4693Request, Tx4693Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_4693_REQUEST.getCode();
  }

  @Override
  public Class<Tx4693Response> getResponse() {
    return Tx4693Response.class;
  }
}
