package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;

/**
 * 4601-开户 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx4601Response extends TxBaseResponse {
  /**
   * 机构编号
   */
  private String institutionID;
  /**
   * 开户流水号
   */
  private String txSN;
  /**
   * 用户 ID
   */
  private String userID;
  /**
   * 状态:
   * <p>
   * 20=处理中
   * 30=成功
   * 40=失败
   */
  private String status;
  /**
   * 绑卡状态:
   * <p>
   * 10=已受理
   * 20=处理中
   * 30=成功
   * 40=失败
   * <p>
   * 开户并绑卡时出现且非空;
   */
  private String bindingStatus;
  /**
   * 电子账户名称
   */
  private String eAccountName;
  /**
   * 电子账户号码
   */
  private String eAccountNumber;
  /**
   * 响应码
   */
  private String responseCode;
  /**
   * 响应消息
   */
  private String responseMessage;

  public Tx4601Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.institutionID = XmlUtils.getNodeText(document, "InstitutionID");
      this.txSN = XmlUtils.getNodeText(document, "TxSN");
      this.userID = XmlUtils.getNodeText(document, "UserID");
      this.eAccountName = XmlUtils.getNodeText(document, "EAccountName");
      this.eAccountNumber = XmlUtils.getNodeText(document, "EAccountNumber");
      this.status = XmlUtils.getNodeText(document, "Status");
      this.bindingStatus = XmlUtils.getNodeText(document, "BindingStatus");
      this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
      this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
    }
  }
}
