package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;

/**
 * 4611-绑卡 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx4613Response extends TxBaseResponse {
  /**
   * 打款截止日期
   * <p>
   * 注:格式:yyyyMMdd;企业银行账户绑定时不为空;可验证有效期自申请之日起 3个自然日
   */
  private String deadLine;
  /**
   * 剩余可验证次数
   * <p>
   * 注:企业银行账户绑定时不为数空;最多可有效验证3次
   */
  private String availableVeriCount;
  /**
   * 状态:
   * <p>
   * 18=被动已打款待验证
   * 20=处理中
   * 30=成功
   * 40=失败
   * <p>
   * 注:当企业绑卡确认、打款金额已校验但未成功且剩余可验证次数>=1 时，状态为18=被动已打款待验证;
   * 当接口字段均已校验成功但交易未完成，状态为20=处理中
   */
  private String status;
  /**
   * 线下转账充值开通状态:
   * <p>
   * 10=处理中
   * 20=成功
   * 30=失败
   */
  private String transferChargeStatus;
  /**
   * 响应码
   */
  private String responseCode;
  /**
   * 响应消息
   */
  private String responseMessage;

  public Tx4613Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.availableVeriCount = XmlUtils.getNodeText(document, "AvailableVeriCount");
      this.deadLine = XmlUtils.getNodeText(document, "DeadLine");
      this.status = XmlUtils.getNodeText(document, "Status");
      this.transferChargeStatus = XmlUtils.getNodeText(document, "TransferChargeStatus");
      this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
      this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
    }
  }
}
