package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;

/**
 * 4616-开户/绑卡查询 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx4616Response extends TxBaseResponse {
  /**
   * 用户 ID
   */
  private String userID;
  /**
   * 归属父级用户 ID
   */
  private String parentUserID;
  /**
   * 状态:
   *
   * 10=已受理
   * 15=待短信验证
   * 16=审核通过
   * 17=待被动打款验证
   * 18=被动已打款待验证
   * 20=处理中
   * 30=成功
   * 40=失败
   */
  private String status;
  /**
   * 绑卡状态:
   *
   * 10=已受理
   * 20=处理中
   * 30=成功
   * 40=失败
   */
  private String bindingStatus;
  /**
   * 银行账户号码
   */
  private String bankAccountNumber;
  /**
   * 电子账户名称
   */
  private String eAccountName;
  /**
   * 电子账户号码
   */
  private String eAccountNumber;
  /**
   * 剩余可验证次 数
   */
  private String availableVeriCount;
  /**
   * 打款截止日期
   */
  private String deadLine;
  /**
   * 线下转账充值开通状态:
   *
   * 10=处理中
   * 20=成功
   * 30=失败
   */
  private String transferChargeStatus;
  /**
   * 收款用户 ID
   */
  private String payeeUserID;
  /**
   * 收款用户姓名
   */
  private String payeeUserName;
  /**
   * 响应码
   */
  private String responseCode;
  /**
   * 响应消息
   */
  private String responseMessage;

  public Tx4616Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.userID = XmlUtils.getNodeText(document, "UserID");
      this.parentUserID = XmlUtils.getNodeText(document, "ParentUserID");
      this.status = XmlUtils.getNodeText(document, "Status");
      this.bindingStatus = XmlUtils.getNodeText(document, "BindingStatus");
      this.bankAccountNumber = XmlUtils.getNodeText(document, "BankAccountNumber");
      this.eAccountName = XmlUtils.getNodeText(document, "EAccountName");
      this.eAccountNumber = XmlUtils.getNodeText(document, "EAccountNumber");
      this.availableVeriCount = XmlUtils.getNodeText(document, "AvailableVeriCount");
      this.deadLine = XmlUtils.getNodeText(document, "DeadLine");
      this.transferChargeStatus = XmlUtils.getNodeText(document, "TransferChargeStatus");
      this.payeeUserID = XmlUtils.getNodeText(document, "PayeeUserID");
      this.payeeUserName = XmlUtils.getNodeText(document, "PayeeUserName");
      this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
      this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
    }
  }

}
