package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.gatheringaccredit;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;

/**
 * 2734-商户进件 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx2734Response extends TxBaseResponse {

  private String status;

  private String responseCode;

  private String responseMessage;

  private String responseTime;

  public Tx2734Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.status = XmlUtils.getNodeText(document, "Status");
      this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
      this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
      this.responseTime = XmlUtils.getNodeText(document, "ResponseTime");
    }
  }
}
