package com.biz.crm.common.pay.support.cpcn.model;

import lombok.Data;

/**
 * 5011-支付（API）
 * - 条码支付 关心的数据
 *
 * @author hefan
 * @date 2022/08/27
 */
@Data
public class Tx5011ScanPayModel extends Tx5011TransferModel {
  /**
   * 商品名称
   * <p>
   * PaymentWay=02/40/42/80 必填
   */
  private String goodsName;
  /**
   * 条码支付类型:
   * <p>
   * 10=微信
   * 20=支付宝
   * 30=银联
   * 40=聚合码
   */
  private String scanPaymentType;
  /**
   * 条码支付方式:
   * <p>
   * 41=正扫
   * 42=反扫
   */
  private String scanPaymentWay;
  /**
   * 支付场景
   * <p>
   * 10=条码支付
   * 20=声波支付
   * 90=刷脸支付
   * <p>
   * 聚合支付方式 QRPaymentWay 为反扫时必填，默认10=条码支付
   */
  private String paymentScene = "10";
  /**
   * 预下单订单号
   * <p>
   * 支付场景PaymentScene为90-刷脸支付为必输项，且必须与预下单交易一致
   */
  private String preTxSN;
  /**
   * 反扫支付授权码
   */
  private String scanPaymentCode;
  /**
   * 账户类型
   * 11=个人账户（默认）
   * 12=企业账户
   */
  private String accountType = "11";
  /**
   * 信用卡限制标识
   * <p>
   * 10=信用卡可用
   * 20=信用卡不可用
   * 99=无关
   */
  private String scanPaymentLimitFlag = "10";
  /**
   * 取消支付后的前台跳转页面
   * <p>
   * 持卡人取消支付后跳转到此页面，应更换支付流水号后再次唤起支付。
   * 【需要注意】对于同一笔支付流水系统无法进行处理
   */
  private String cancelPayRedirectPageURL;
  /**
   * 页面跳转方式
   * 10=公众号
   * 20=小程序
   * <p>
   * ScanPaymentType=10-微信扫码时此字段为必填项，默认为公众号。
   */
  private String scanPageUrlType = "10";
  /**
   * 成功前台跳转页面
   *
   * 当支付方式为
   * 此页面只用作商家广告宣传等展示，商户后台应只在收到中金后台的支付成功回调通知后，
   * 才能做真正的支付成功通知处理。
   */
  private String redirectPageURL;
  /**
   * 分期控制标识
   * 10-不指定分期
   * 20-指定分期
   *
   * 条码支付类型为 20-支付宝且条码支付方式=41 正扫时生效；
   * 未填写默认为 10-不指定分期。
   * 条码支付类型为 30-银联且条码支付方式=41正扫时生效；
   * 未填写默认为 10-不指定分期。
   */
  private String installmentType = "10";
  /**
   * 手续费收取模式:
   *
   * 10=商户贴息
   * 20=持卡人付费
   *
   * InstallmentType=20时必填
   * 1.条码支付类型为 20-支付宝且条码支付方式=41 正扫，分期控制标识为 20-指定分期时，
   * 手续费收取模式必填且仅允许填 10-商户贴息
   * 2.条码支付类型为 30-银联且条码支付方式=41 正扫时，分期控制标识为 20-指定分期时
   * 手续费收取模式必填，支持 10-商户贴息或 20-持卡人付费
   */
  private String feeMode;
  /**
   * 分期期数
   * 分期控制标识20指定分期时必填
   * 1.条码支付类型为 20-支付宝且条码支付方式=41 正扫，分期控制标识为 20-指定分期时，期数必填；
   * 2.其他情况分期期数非必填，如填写，则条码分期支付时仅支持该期数
   */
  private String numberOfInstallments;
  /**
   * 实名验证信息
   *
   * 保险实名认证商户必填
   */
  private String identityInfo;
  /**
   * AppID(商户进件录入)
   * 微信必填PayType=31支付宝选填(支付宝直连必填)
   */
  private String subAppID;

  /**
   * 机具终端 ID
   *
   * 支付类型ScanPaymentType=30 银联，条码支付方式为 42-反扫时必填
   */
  private String terminalID;
  /**
   * 银行 ID
   *
   * 选填，如填写，则条码分期支付时仅支持该银行
   */
  private String bankID;



}
