package com.biz.crm.common.pay.support.cpcn.service.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.TxService;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate.Tx5011Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate.Tx5011Response;
import com.biz.crm.common.pay.support.cpcn.util.SerialNumberUtils;
import com.biz.crm.common.pay.support.sdk.dto.transfer.TransferDto;
import com.biz.crm.common.pay.support.sdk.model.ResponseModel;
import com.biz.crm.common.pay.support.sdk.service.CustomerPaySupportVoService;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.carrier.TransferCarrier;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.convertor.TransferConvertor;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 客户支付
 * - 中金认为这是一种支付行为
 * - 所以使用中金：5011-支付（API）
 *
 * @author hefan
 * @date 2022/08/19
 */
@Service("cpcnCustomerPaySupportService")
public class CustomerPaySupportVoServiceImpl implements CustomerPaySupportVoService {

  @Autowired(required = false)
  private TxService<Tx5011Response> tx5011Service;

  @Autowired(required = false)
  private List<TransferConvertor<Tx5011Request, Tx5011Response>> transferConvertors;

  @Override
  public ResponseModel pay(TransferCarrier transfer) {
    /**
     * 客户支付：经销商 向 品牌商 转账
     * - 根据入参类型决定转成何种支付模型
     */
    TransferConvertor convertor = null;
    for (TransferConvertor transferConvertor : transferConvertors) {
      if (!transferConvertor.isConvertible(transfer)) {
        continue;
      }
      convertor = transferConvertor;
      break;
    }
    Validate.notNull(convertor, "中金业务数据转换失败");
    Tx5011Request tx5011Request = (Tx5011Request) convertor.convert(transfer);
    Tx5011Response tx5011Response = tx5011Service.handlerTx(CpcnRequestType.TX_5011_REQUEST.getCode(), tx5011Request);
    // 解析返回数据
    return convertor.parseResponse(tx5011Response);
  }
}
