package com.biz.crm.common.pay.support.cpcn.service.internal;

import com.biz.crm.common.pay.support.cpcn.util.SerialNumberUtils;
import com.biz.crm.common.pay.support.sdk.dto.transfer.TransferDto;
import com.biz.crm.common.pay.support.sdk.model.ResponseModel;
import com.biz.crm.common.pay.support.sdk.service.CustomerPaySupportVoService;
import com.biz.crm.common.pay.support.sdk.service.CustomerRechargeSupportVoService;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.carrier.TransferCarrier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/**
 * 客户充值
 * - 中金认为这是一种支付行为
 * - 所以使用中金：5011-支付（API）
 *
 * @author hefan
 * @date 2022/08/19
 */
@Service
public class CustomerRechargeSupportVoServiceImpl implements CustomerRechargeSupportVoService {

  @Qualifier("cpcnCustomerPaySupportService")
  @Autowired(required = false)
  private CustomerPaySupportVoService customerPaySupportVoService;

  @Override
  public ResponseModel recharge(TransferCarrier transfer) {
    /**
     * 客户充值：经销商 向 品牌商 转账
     * 根据入参类型决定转成何种支付模型
     */
    return customerPaySupportVoService.pay(transfer);
  }


}
