package com.biz.crm.common.pay.support.cpcn.service.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnBillTransactionStatus;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.TxService;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4643Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4643Response;
import com.biz.crm.common.pay.support.cpcn.util.SerialNumberUtils;
import com.biz.crm.common.pay.support.sdk.dto.ExtractCashDto;
import com.biz.crm.common.pay.support.sdk.model.ResponseModel;
import com.biz.crm.common.pay.support.sdk.service.BankAccountSupportVoService;
import com.biz.crm.common.pay.support.sdk.service.ExtractCashService;
import com.biz.crm.common.pay.support.sdk.vo.BankAccountSupportVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 提取现金服务impl
 *
 * @author hefan
 * @date 2022/08/10
 */
@Service
public class ExtractCashServiceImpl implements ExtractCashService {
  @Autowired
  private TxService<Tx4643Response> tx4643Service;

  @Autowired
  private CpcnConfig cpcnConfig;

  @Override
  public ResponseModel sendRequest(ExtractCashDto extractCashDto) {
    /**
     * 4643-提现
     */
    Tx4643Request tx4643Request = this.getTx4643Request(extractCashDto);
    // 发起提现请求
    Tx4643Response response = tx4643Service.handlerTx(CpcnRequestType.TX_4643_REQUEST.getCode(), tx4643Request);
    // 返回处理
    return this.parseResponse(response);
  }

  /**
   * 解析响应
   *
   * @param response 响应
   * @return {@link ResponseModel}
   */
  private ResponseModel parseResponse(Tx4643Response response) {
    String code = response.getCode();
    boolean isSuccess = Constants.SUCCESS_CODE.equals(code);
    ResponseModel responseModel = new ResponseModel();
    responseModel.setSuccess(isSuccess);
    if (!isSuccess) {
      responseModel.setMessage(response.getMessage());
      return responseModel;
    }
    String status = response.getStatus();
    boolean isFail = CpcnBillTransactionStatus.FAIL.getCode().equals(status);
    responseModel.setSuccess(!isFail);
    boolean isDelay = CpcnBillTransactionStatus.PROCESSING.getCode().equals(status);
    responseModel.setDelay(isDelay);
    responseModel.setMessage(response.getResponseMessage());
    return responseModel;
  }

  /**
   * 构建 中金的 4643 请求对象
   *
   * @return {@link Tx4643Request}
   */
  private Tx4643Request getTx4643Request(ExtractCashDto extractCashDto) {
    Tx4643Request tx4643Request = new Tx4643Request();
    // R 必填
    tx4643Request.setTxCode(CpcnRequestType.TX_4643_REQUEST.getCode());
    //InstitutionID 后续代码会从系统配置里取
    tx4643Request.setTxSN(SerialNumberUtils.create());
    tx4643Request.setUserID(extractCashDto.getUserID());
    String bindingTxSN = this.getBindingTxSN(extractCashDto.getBankAccountNumber(), "", extractCashDto.getUserID());
    tx4643Request.setBindingTxSN(bindingTxSN);
    tx4643Request.setAmount(extractCashDto.getAmount());
    tx4643Request.setArrivalType(extractCashDto.getArrivalType());
    // O 选填
    tx4643Request.setRemark(extractCashDto.getRemark());
    tx4643Request.setNoticeURL(cpcnConfig.getNoticeUrl());
    /**
     *注意项目：
     * 1.提现交易实时返回受理状态，支付平台默认 T+1 日出金（支持 T0 出金，
     * 需特殊配置），机构系统通过 4656-提现查询或 4658-提现通知接口同步提现状
     * 态。
     *  2.若收款银行为农行且收款账户是长度为 15 位的企业账户（即账户未加省
     * 号），则省份和城市必填
     */
    return tx4643Request;
  }

  @Autowired(required = false)
  private BankAccountSupportVoService bankAccountSupportVoService;

  /**
   * 获取绑定tx sn
   *
   * @return {@link String}
   */
  private String getBindingTxSN(String bankAccountNumber, String mainUserID, String userID) {
    BankAccountSupportVo bankAccountSupportVo = bankAccountSupportVoService.findByBankAccountNumber(bankAccountNumber, mainUserID, userID);
    return bankAccountSupportVo.getBindingTxSN();
  }

}
