package com.biz.crm.common.pay.support.cpcn.service.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.TxService;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4691Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4691Response;
import com.biz.crm.common.pay.support.sdk.service.PaymentAccountSupportVoService;
import com.biz.crm.common.pay.support.sdk.vo.PaymentAccountSupportVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 账户VO service 实现
 *
 * @author hefan
 * @date 2022/08/08
 */
@Service
public class PaymentAccountSupportVoServiceImpl implements PaymentAccountSupportVoService {

  @Autowired(required = false)
  private TxService<Tx4691Response> tx4691Service;

  @Override
  public PaymentAccountSupportVo findByUserId(String userID) {
    /**
     * 暂定：使用中金 4691-用户信息查询
     */
    Tx4691Request tx4691Request = this.getTx4691Request(userID);
    // 提交 用户信息查询请求
    Tx4691Response tx4691Response = tx4691Service.handlerTx(CpcnRequestType.TX_4691_REQUEST.getCode(), tx4691Request);
    // 返回处理
    return this.parseResponse(tx4691Response);
  }

  /**
   * 解析响应
   *
   * @param response tx4691响应
   */
  private PaymentAccountSupportVo parseResponse(Tx4691Response response) {
    String code = response.getCode();
    boolean isSuccess = Constants.SUCCESS_CODE.equals(code);
    if (!isSuccess) {
      throw new RuntimeException(response.getMessage());
    }
    PaymentAccountSupportVo paymentAccountSupportVo = new PaymentAccountSupportVo();
    paymentAccountSupportVo.setUserName(response.getUserName());
    paymentAccountSupportVo.setUserID(response.getUserID());
    paymentAccountSupportVo.setParentUserID(response.getParentUserID());
    paymentAccountSupportVo.setBalance(response.getBalance());
    paymentAccountSupportVo.setReceivedBalance(response.getReceivedBalance());
    paymentAccountSupportVo.setReceivableBalance(response.getReceivableBalance());
    paymentAccountSupportVo.setFrozenAmount(response.getFrozenAmount());
    paymentAccountSupportVo.setUserType(response.getUserType());
    paymentAccountSupportVo.setStatus(response.getStatus());
    return paymentAccountSupportVo;
  }

  /**
   * 构建 中金的4691 请求对象
   *
   * @return {@link Tx4691Request}
   */
  private Tx4691Request getTx4691Request(String userID) {
    Tx4691Request tx4691Request = new Tx4691Request();
    tx4691Request.setTxCode(CpcnRequestType.TX_4691_REQUEST.getCode());
    tx4691Request.setUserID(userID);
    return tx4691Request;
  }


}
