/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.support.cpcn.base.common.http.internal;

import com.biz.crm.common.pay.support.cpcn.base.common.http.HttpData;
import com.biz.crm.common.pay.support.cpcn.base.common.http.HttpsConnection;
import com.biz.crm.common.pay.support.cpcn.base.common.http.NameValuePair;
import com.biz.crm.common.pay.support.cpcn.base.common.http.ResponseDgtEnvlp;
import com.biz.crm.common.pay.support.cpcn.base.common.http.SecurityContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.lang3.Validate;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsClientConnection
implements HttpsConnection {
    private static final Logger log = LoggerFactory.getLogger(HttpsClientConnection.class);
    private int connectTimeout = 50000;
    private int readTimeout = 50000;
    private String outputCharset = "UTF-8";
    private String inputCharset = "UTF-8";
    private String contentType = "application/x-www-form-urlencoded";
    private boolean ignoreHostname = true;

    @Override
    public String execute(String uri, List<NameValuePair> list) {
        HttpData httpData = new HttpData(list, this.outputCharset);
        String request = httpData.getData();
        return this.execute(uri, request);
    }

    @Override
    public ResponseDgtEnvlp executeRequest(String uri, List<NameValuePair> list) {
        HttpData httpData = new HttpData(list, this.outputCharset);
        String request = httpData.getData();
        HttpResponse httpResponse = this.sendPost(uri, request);
        HttpEntity httpEntity = httpResponse.getEntity();
        Validate.notNull((Object)httpEntity, (String)"httpclient\u8bf7\u6c42\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u5730\u5740\uff01", (Object[])new Object[0]);
        String response = null;
        try (InputStream inputStream = httpEntity.getContent();){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int num = inputStream.read(buffer);
            while (num != -1) {
                baos.write(buffer, 0, num);
                num = inputStream.read(buffer);
            }
            baos.flush();
            response = baos.toString(this.inputCharset).trim();
        }
        catch (IOException e) {
            log.error("httpclient \u8bf7\u6c42\u9519\u8bef", (Throwable)e);
            throw new RuntimeException(e);
        }
        ResponseDgtEnvlp responseDgtEnvlp = new ResponseDgtEnvlp();
        responseDgtEnvlp.setResponsetext(response);
        if (httpResponse.getFirstHeader("isDgEnv") != null) {
            responseDgtEnvlp.setIsDgEnv(httpResponse.getFirstHeader("isDgEnv").getValue());
        }
        if (httpResponse.getFirstHeader("digitalEnvelope") != null) {
            responseDgtEnvlp.setDgtlEnvlp(httpResponse.getFirstHeader("digitalEnvelope").getValue());
        }
        if (httpResponse.getFirstHeader("signAlgorithm") != null) {
            responseDgtEnvlp.setSignAlgorithm(httpResponse.getFirstHeader("signAlgorithm").getValue());
        }
        if (httpResponse.getFirstHeader("encryptSN") != null) {
            responseDgtEnvlp.setEncryptSN(httpResponse.getFirstHeader("encryptSN").getValue());
        }
        if (httpResponse.getFirstHeader("signSN") != null) {
            responseDgtEnvlp.setSignSN(httpResponse.getFirstHeader("signSN").getValue());
        }
        return responseDgtEnvlp;
    }

    private HttpResponse sendPost(String uri, String request) {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        Object hostnameVerifier = this.ignoreHostname ? NoopHostnameVerifier.INSTANCE : new DefaultHostnameVerifier();
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(SecurityContext.sslContext, (HostnameVerifier)hostnameVerifier);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory).register("http", (Object)new PlainConnectionSocketFactory()).build();
        clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory);
        clientBuilder.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(registry));
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setConnectTimeout(this.readTimeout).setSocketTimeout(50000).build();
        clientBuilder.setDefaultRequestConfig(requestConfig);
        CloseableHttpClient httpClient = clientBuilder.build();
        HttpPost httpPost = new HttpPost(uri);
        BasicHeader basicHeader = new BasicHeader("Content-Type", this.contentType);
        httpPost.addHeader((Header)basicHeader);
        try {
            StringEntity stringEntity = new StringEntity(request, ContentType.APPLICATION_FORM_URLENCODED.withCharset(this.outputCharset));
            httpPost.setEntity((HttpEntity)stringEntity);
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost);
            Validate.notNull((Object)closeableHttpResponse, (String)"httpclient\u8bf7\u6c42\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u5730\u5740\uff01", (Object[])new Object[0]);
            return closeableHttpResponse;
        }
        catch (IOException e) {
            log.error("httpclient \u8bf7\u6c42\u9519\u8bef", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String execute(String uri, String request) {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        Object hostnameVerifier = this.ignoreHostname ? NoopHostnameVerifier.INSTANCE : new DefaultHostnameVerifier();
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(SecurityContext.sslContext, (HostnameVerifier)hostnameVerifier);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory).register("http", (Object)new PlainConnectionSocketFactory()).build();
        clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory);
        clientBuilder.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(registry));
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setConnectTimeout(this.readTimeout).setSocketTimeout(50000).build();
        clientBuilder.setDefaultRequestConfig(requestConfig);
        CloseableHttpClient httpClient = clientBuilder.build();
        HttpPost httpPost = new HttpPost(uri);
        BasicHeader basicHeader = new BasicHeader("Content-Type", this.contentType);
        httpPost.addHeader((Header)basicHeader);
        String response = null;
        HttpEntity httpEntity = null;
        try {
            StringEntity stringEntity = new StringEntity(request, ContentType.APPLICATION_FORM_URLENCODED.withCharset(this.outputCharset));
            httpPost.setEntity((HttpEntity)stringEntity);
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost);
            httpEntity = closeableHttpResponse.getEntity();
        }
        catch (IOException e) {
            log.error("httpclient \u8bf7\u6c42\u9519\u8bef", (Throwable)e);
            throw new RuntimeException(e);
        }
        Validate.notNull((Object)httpEntity, (String)"httpclient\u8bf7\u6c42\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u5730\u5740\uff01", (Object[])new Object[0]);
        try (InputStream inputStream = httpEntity.getContent();){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int num = inputStream.read(buffer);
            while (num != -1) {
                baos.write(buffer, 0, num);
                num = inputStream.read(buffer);
            }
            baos.flush();
            response = baos.toString(this.inputCharset).trim();
        }
        catch (IOException e) {
            log.error("httpclient \u8bf7\u6c42\u9519\u8bef", (Throwable)e);
            throw new RuntimeException(e);
        }
        return response;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public void setOutputCharset(String outputCharset) {
        this.outputCharset = outputCharset;
    }

    @Override
    public void setInputCharset(String inputCharset) {
        this.inputCharset = inputCharset;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public void setIgnoreHostname(boolean ignoreHostname) {
        this.ignoreHostname = ignoreHostname;
    }
}

