package com.biz.crm.common.pay.support.cpcn.base.common.security;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.util.Base64;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.EncryptUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import com.biz.crm.common.pay.support.cpcn.base.common.utils.PayUtils;
import com.biz.crm.common.pay.support.cpcn.base.common.utils.SM4Utils;

import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;

/**
 * 国密加密
 *
 * @author Keller
 */
public class SMSigner implements Signer{

  private PrivateKey privateKey;

  private X509Cert x509Cert;

  private static final Mechanism mechanism = new Mechanism("SM2");

  private static Session session;

  public SMSigner(String filename, String password) throws Exception {
    this(filename, password, null);
  }

  public SMSigner(String filename, String password, String serviceID) throws Exception {
    this.x509Cert = CertUtil.getCertFromSM2(filename);
    this.privateKey = (PrivateKey) KeyUtil.getPrivateKeyFromSM2(filename, password);
    JCrypto.getInstance().initialize("JSOFT_LIB", null);
    session = JCrypto.getInstance().openSession("JSOFT_LIB");
  }

  @Override
  public String sign(String message) throws Exception {
    return PayUtils.bytes2hex(sign(message.getBytes()));
  }

  @Override
  public byte[] sign(byte[] data, String algorithm) throws Exception {
    return sign(data);
  }

  @Override
  public byte[] sign(byte[] data) throws Exception {
    Signature signature = new Signature();
    return Base64.decode(signature.p1SignMessage("sm3WithSM2Encryption", data, this.privateKey, session));
  }

  @Override
  public String decrypt(String message, String digitalEnvelope) throws Exception {
    byte[] prefixBytes = new byte[3];
    byte[] keyBytes = new byte[16];
    byte[] envelopeBytes = EncryptUtil.decrypt(mechanism, this.privateKey, digitalEnvelope.getBytes(), session);
    System.arraycopy(envelopeBytes, 0, prefixBytes, 0, 3);
    System.arraycopy(envelopeBytes, 3, keyBytes, 0, 16);
    String prefixStr = new String(prefixBytes, "UTF-8");
    return prefixStr.equals("02|") ? SM4Utils.decryptByECB(message, keyBytes) : "";
  }

  @Override
  public String getSN() {
    return String.valueOf(this.x509Cert.getStringSerialNumber());
  }

  @Override
  public String decrypt(String message) throws Exception {
    return new String(EncryptUtil.decrypt(mechanism, this.privateKey, message.getBytes(), session), StandardCharsets.UTF_8);
  }

  @Override
  public String getSymmetricCipher() {
    return PayUtils.randomHexString(16);
  }

  @Override
  public String getAlgorithm() {
    return this.x509Cert.getSignatureAlgName();
  }


}
