package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseResponse;
import com.google.common.collect.Lists;
import lombok.Getter;
import lombok.Setter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.util.Collection;

/**
 * 4693-绑定银行账户查询(API) 响应报文
 *
 * @author hefan
 * @date 2022/08/11
 */
@Getter
public class Tx4693Response extends TxBaseResponse {

  private String userID;

  private Collection<BankAccount> bankAccounts;

  public Tx4693Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.userID = XmlUtils.getNodeText(document, "UserID");
      NodeList nodeList = document.getElementsByTagName("BankAccounts");
      int len = nodeList.getLength();
      this.bankAccounts = Lists.newArrayListWithCapacity(len);
      for (int i = 0; i < len; ++i) {
        Node node = nodeList.item(i);
        String bindingTxSN = XmlUtils.getChildNodeText(node, "BindingTxSN");
        String bankID = XmlUtils.getChildNodeText(node, "BankID");
        String bankAccountType = XmlUtils.getChildNodeText(node, "BankAccountType");
        String bankAccountName = XmlUtils.getChildNodeText(node, "BankAccountName");
        String bankAccountNumber = XmlUtils.getChildNodeText(node, "BankAccountNumber");
        String branchName = XmlUtils.getChildNodeText(node, "BranchName");
        String bankPhoneNumber = XmlUtils.getChildNodeText(node, "BankPhoneNumber");
        String cardBusinessType = XmlUtils.getChildNodeText(node, "CardBusinessType");
        BankAccount bankAccounts = new BankAccount();
        bankAccounts.setBindingTxSN(bindingTxSN);
        bankAccounts.setBankID(bankID);
        bankAccounts.setBankAccountType(bankAccountType);
        bankAccounts.setBankAccountName(bankAccountName);
        bankAccounts.setBankAccountNumber(bankAccountNumber);
        bankAccounts.setBranchName(branchName);
        bankAccounts.setBankPhoneNumber(bankPhoneNumber);
        bankAccounts.setCardBusinessType(cardBusinessType);
        this.bankAccounts.add(bankAccounts);
      }
    }
  }

  @Getter
  @Setter
  public class BankAccount {

    /**
     * 银行账户绑定流水号
     */
    private String bindingTxSN;
    /**
     * 开户行 ID
     * - 注：参考《银行编码表》
     */
    private String bankID;
    /**
     * 账户类型：
     * 11=个人账户
     * 12=企业账户
     */
    private String bankAccountType;
    /**
     * 账户名称
     */
    private String bankAccountName;
    /**
     * 账户号码
     * - 注：只返回账号的最后 4 位数字
     */
    private String bankAccountNumber;
    /**
     * 分支行名称
     */
    private String branchName;
    /**
     * 银行卡预留手机号码
     * - 注：只返回后 4 位
     */
    private String bankPhoneNumber;
    /**
     * 绑定卡类型：
     * 10=快捷卡
     * 20=提现卡
     */
    private String cardBusinessType;
    /**
     * 线下转账充值开通标识：
     * 10=未开通
     * 20=已开通
     * 30=已取消
     */
    private String transferChargeFlag;
    /**
     * 收款用户 ID
     */
    private String payeeUserID;
    /**
     * 收款用户姓名
     */
    private String payeeUserName;
  }

}
