package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnNoticeType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.notice.Notice2736Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.notice.NoticeRequest;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.notifier.Notice2736Listener;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.NoticeStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 7709-壹企付用户签约成功后台通知
 * <pre>
 *   2734-商户进件交易提交后，
 *   如果如果交易状态变为
 *    “30 - 正反 扫权限已获取，其他待处理”、
 *    “40 - 全部权限已获取”、
 *    “50 - 失败 时”三者之一时，支付平台会给机构系统发送商户进件状态变更通知，
 *   支付平台将后台通知发送到机构在上线申请表中提供的后台通 知地址。机构系统收到该通知后需要给支付平台返回固定的响应， 如果支付平台在 5 秒内未收到机构系统返回的通知响应或者接收到 的响应内容与规定内容不符，支付平台会认为机构系统未成功收到 该通知，这时支付平台会向机构系统补发通知，最多补发两次，共
 * 发三次。
 * </pre>
 *
 * @author Keller
 */
@Slf4j
@Component
public class Notice2736Strategy implements NoticeStrategy<Notice2736Request> {
  @Autowired(required = false)
  private List<Notice2736Listener> notice2736Listeners;

  @Override
  public String getCode() {
    return CpcnNoticeType.NOTICE_2736.getCode();
  }

  @Override
  public Notice2736Request exchange(NoticeRequest request) throws Exception {
    return new Notice2736Request(request.getDocument());
  }

  @Override
  public void handler(NoticeRequest request) {
    try {
      Notice2736Request notice2736Request = exchange(request);
      // 事件通知
      if (!CollectionUtils.isEmpty(notice2736Listeners)) {
        for (Notice2736Listener listener : notice2736Listeners) {
          listener.onNotice(notice2736Request);
        }
      }
    } catch (Exception e) {
      log.error("壹企付用户签约成功后台通知出现错误", e);
      throw new RuntimeException(e.getLocalizedMessage());
    }
  }
}
