package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.AbstractTxStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4698Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4698Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 4698-电子回单下载
 *
 * <pre>
 * 用于机构系统从支付平台获取指定交易电子回单的环节，机构系统通过该接口将请求发送到支付平台，
 * 支付平台收到请求后立即处理，并将处理结果实时返回给机构系统。
 * 机构系统成功获得响应后，可通过 DownLoadURL 字段的地址下载电子回单。
 * 注:可支持中金存管模式和银行存管模式的电子回单下载。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx4698Strategy extends AbstractTxStrategy<Tx4698Request, Tx4698Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_4698_REQUEST.getCode();
  }

  @Override
  public Class<Tx4698Response> getResponse() {
    return Tx4698Response.class;
  }
}
