package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.validation.constraints.NotBlank;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 4693-绑定银行账户查询(API) 请求报文
 *
 * @author hefan
 * @date 2022/08/11
 */
@Getter
@Setter
@ToString
public class Tx4693Request extends TxBaseRequest {

  /**
   * 主用户 ID
   */
  private String mainUserID;

  /**
   * 用户 ID
   */
  @NotBlank(message = "用户 ID不能为空")
  private String userID;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element Body = document.createElement("Body");
    Element TxCode = document.createElement("TxCode");
    Element InstitutionID = document.createElement("InstitutionID");
    Element MainUserID = document.createElement("MainUserID");
    Element UserID = document.createElement("UserID");
    document.appendChild(Request);
    Request.setAttribute("version", "2.1");
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Body.appendChild(MainUserID);
    MainUserID.setTextContent(this.mainUserID);
    Body.appendChild(UserID);
    UserID.setTextContent(this.userID);
    postProcess(document);
  }


}
