package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 4616-开户/绑卡查询
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx4616Request extends TxBaseRequest {
  /**
   * 原业务流水号
   */
  private String sourceTxSN;
  /**
   * 原业务交易编码:
   *
   * 4601=开户
   * 4611=绑卡
   */
  private String sourceTxCode;
  /**
   * 操作标识:
   *
   * 10=绑卡
   * 20=解绑
   * 30=升级
   */
  private String operationFlag;
  /**
   * 用户类型:
   *
   * 11=个人用户
   * 12=企业用户
   * 13=个体工商
   */
  private String userType;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element Body = document.createElement("Body");
    Element TxCode = document.createElement("TxCode");
    Element InstitutionID = document.createElement("InstitutionID");
    Element SourceTxSN = document.createElement("SourceTxSN");
    Element SourceTxCode = document.createElement("SourceTxCode");
    Element OperationFlag = document.createElement("OperationFlag");
    Element UserType = document.createElement("UserType");
    document.appendChild(Request);
    Request.setAttribute("version", "2.1");
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Body.appendChild(SourceTxSN);
    SourceTxSN.setTextContent(this.sourceTxSN);
    Body.appendChild(SourceTxCode);
    SourceTxCode.setTextContent(this.sourceTxCode);
    Body.appendChild(OperationFlag);
    OperationFlag.setTextContent(this.operationFlag);
    Body.appendChild(UserType);
    UserType.setTextContent(this.userType);
    postProcess(document);
  }
}

