package com.biz.crm.common.pay.support.cpcn.service.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.TxService;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4665Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4665Response;
import com.biz.crm.common.pay.support.cpcn.util.SerialNumberUtils;
import com.biz.crm.common.pay.support.sdk.model.ResponseModel;
import com.biz.crm.common.pay.support.sdk.service.WhiteListSupportVoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 白名单
 *
 * @author hefan
 * @date 2022/08/16
 */
@Service
public class WhiteListSupportVoServiceImpl implements WhiteListSupportVoService {

  @Autowired(required = false)
  private TxService<Tx4665Response> tx4665Service;

  @Override
  public ResponseModel create(String bankAccountName, String bankAccountNumber, String payeeMainUserID, String payeeUserID) {
    /**
     * 4665-白名单开通/注销
     */
    String whiteListType = "10";
    String operation = "10";
    Tx4665Request tx4665Request = this.getTx4665Request(whiteListType, operation, bankAccountName, bankAccountNumber, payeeMainUserID, payeeUserID);
    //
    Tx4665Response response = tx4665Service.handlerTx(CpcnRequestType.TX_4665_REQUEST.getCode(), tx4665Request);
    //
    return this.parse(response);
  }

  /**
   * 解析
   *
   * @param response 响应
   */
  private ResponseModel parse(Tx4665Response response) {
    String code = response.getCode();
    boolean isSuccess = Constants.SUCCESS_CODE.equals(code);
    ResponseModel responseModel = new ResponseModel();
    responseModel.setSuccess(isSuccess);
    if (!isSuccess) {
      responseModel.setMessage(response.getMessage());
      return responseModel;
    }
    responseModel.setMessage(response.getResponseMessage());
    String status = response.getStatus();
    isSuccess = "20".equals(status);
    if (isSuccess) {
      return responseModel;
    }
    boolean isDelay = "10".equals(status);
    responseModel.setDelay(isDelay);
    return responseModel;
  }

  /**
   * 构建 4665 请求
   *
   * @return {@link Tx4665Request}
   */
  private Tx4665Request getTx4665Request(String whiteListType, String operation, String bankAccountName,
                                         String bankAccountNumber, String payeeMainUserID, String payeeUserID) {
    Tx4665Request tx4665Request = new Tx4665Request();
    // R
    tx4665Request.setTxCode(CpcnRequestType.TX_4665_REQUEST.getCode());
    tx4665Request.setTxSN(SerialNumberUtils.create());
    tx4665Request.setWhiteListType(whiteListType);
    tx4665Request.setOperation(operation);
    tx4665Request.setBankAccountName(bankAccountName);
    tx4665Request.setBankAccountNumber(bankAccountNumber);
    // O
    tx4665Request.setPayeeMainUserID(payeeMainUserID);
    tx4665Request.setPayeeUserID(payeeUserID);
    return tx4665Request;
  }

}
