package com.biz.crm.common.pay.support.cpcn.base.common.utils;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;

/**
 * AES128 加密工具类
 *
 * @author Keller
 */
public final class Aes128Utils {

  /**
   * 秘钥长度
   */
  private static final int KEY_LENGTH = 16;

  private Aes128Utils() {
    throw new UnsupportedOperationException("静态工具类，不支持实例化");
  }

  /**
   * AES128 加密
   *
   * @param explainMessage
   * @param key
   * @return
   * @throws Exception
   */
  public static String encrypt(String explainMessage, String key) throws Exception {
    if (StringUtils.isEmpty(explainMessage) || StringUtils.isEmpty(key) || key.length() != KEY_LENGTH) {
      return null;
    }
    byte[] raw = key.getBytes(StandardCharsets.UTF_8);
    SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
    Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
    cipher.init(1, skeySpec);
    byte[] encrypted = cipher.doFinal(explainMessage.getBytes(StandardCharsets.UTF_8));
    return Base64.encodeBase64String(encrypted);
  }

  /**
   * AES128 解密
   *
   * @param encryptMessage
   * @param key
   * @return
   * @throws Exception
   */
  public static String decrypt(String encryptMessage, String key) throws Exception {
    if (StringUtils.isEmpty(encryptMessage) || StringUtils.isEmpty(key) || key.length() != KEY_LENGTH){
    return null;
  }
    byte[] raw = key.getBytes(StandardCharsets.UTF_8);
    SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
    Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
    cipher.init(2, skeySpec);
    byte[] encrypted1 = (new Base64()).decode(encryptMessage);
    byte[] original = cipher.doFinal(encrypted1);
    return new String(original, StandardCharsets.UTF_8);
  }
}
