package com.biz.crm.common.pay.support.cpcn.base.common.http;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;

/**
 * 网络请求参数数据封装
 *
 * @author Keller
 */
public class HttpData {
  /**
   * 日志
   */
  private Logger log = LoggerFactory.getLogger(HttpData.class);
  /**
   * 参数
   */
  private List<NameValuePair> params;
  /**
   * 字符集
   */
  private String charset;

  public HttpData(List<NameValuePair> params, String charset) {
    this.params = params;
    this.charset = charset;
  }

  /**
   * 获取拼接的参数字符串
   *
   * @return
   */
  public String getData() {
    StringBuilder sb = new StringBuilder();
    if (!CollectionUtils.isEmpty(this.params)) {
      for (NameValuePair nv : this.params) {
        try {
          sb.append(String.format("%s=%s&", nv.getName(), URLEncoder.encode(nv.getValue(), charset)));
        } catch (UnsupportedEncodingException e) {
          log.error("请求参数转化错误", e);
          throw new IllegalArgumentException(e);
        }
      }
      return sb.deleteCharAt(sb.length() - 1).toString();
    }
    return "";
  }
}
