/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.support.cpcn.base.common.utils;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.util.EncryptUtil;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;

public final class SM4Utils {
    private static final Mechanism SM4_ECB_ME = new Mechanism("SM4/ECB/PKCS7Padding");
    private static Session session;

    private SM4Utils() {
        throw new UnsupportedOperationException("\u9759\u6001\u5de5\u5177\u7c7b\uff0c\u4e0d\u652f\u6301\u5b9e\u4f8b\u5316");
    }

    public static String encrypt(String plainText, String key) throws Exception {
        return SM4Utils.encrypt(plainText.getBytes(), key);
    }

    public static String encrypt(byte[] plainText, String key) throws Exception {
        return new String(EncryptUtil.encryptMessageBySM4((byte[])plainText, (String)key), StandardCharsets.UTF_8);
    }

    public static String decrypt(String cipherText, String key) throws Exception {
        return SM4Utils.decrypt(cipherText.getBytes(), key);
    }

    public static String decrypt(byte[] cipherText, String key) throws Exception {
        return new String(EncryptUtil.decryptMessageBySM4((byte[])cipherText, (String)key), StandardCharsets.UTF_8);
    }

    public static String decryptByECB(String message, byte[] keyBytes) throws Exception {
        byte[] messageBytes = message.getBytes("UTF-8");
        SecretKeySpec key = new SecretKeySpec(keyBytes, "SM4");
        byte[] base64Bytes = EncryptUtil.decrypt((Mechanism)SM4_ECB_ME, (Key)key, (byte[])messageBytes, (Session)session);
        return new String(base64Bytes, "UTF-8");
    }

    public static String encryptByECB(String message, String symmetricCipher) throws Exception {
        byte[] symmetricCipherBytes = symmetricCipher.getBytes("UTF-8");
        byte[] messageBytes = message.getBytes("UTF-8");
        SecretKeySpec key = new SecretKeySpec(symmetricCipherBytes, "SM4");
        byte[] base64Bytes = EncryptUtil.encrypt((Mechanism)SM4_ECB_ME, (Key)key, (byte[])messageBytes, (Session)session);
        return new String(base64Bytes, "UTF-8");
    }

    static {
        try {
            JCrypto.getInstance().initialize("JSOFT_LIB", null);
            session = JCrypto.getInstance().openSession("JSOFT_LIB");
        }
        catch (PKIException var1) {
            var1.printStackTrace();
        }
    }
}

