package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnNoticeType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.notice.Notice4618Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.notice.NoticeRequest;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.notifier.Notice4618Listener;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.NoticeStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 4618-开户/绑卡结果通知
 * <pre>
 *   支付平台收到机构系统发送的4601-开户和4611-绑卡/4613-绑卡确认的交易请求后会进行处理，
 *   如果机构系统实时收到4601或4613接口的响应中交易状态不是“30=成功”或“40=失败”，
 *   那么后续当交易状态变更为“18=被动 已打款待验证”、“30=成功”、“40=失败”三种状态之一时，
 *   支付平台会给机构系统发送该笔交易的结果通知(优先向 4601 或 4611 接口上送的后台通知地址发送，
 *   4601 或 4611 接口没有上送则向机构系统在上线申请时提供的后台通知地址发送)。
 *   机构系统收到该通知后需要给支付平台返回特定的响应，
 *   如果支付平台在5 秒内未收到机构系统返回的通知响应或接收到的响应内容与规定内容不符，
 *   支付平台会认为机构系统未成功收到该通知，这时支付平台会向机构系统补发通知，最多补发7次，共发8次，
 *   各次发送时间间隔为: 0s/30s/30s/3m/10m/20m/30m/1h。
 * </pre>
 *
 * @author Keller
 */
@Slf4j
@Component
public class Notice4618Strategy implements NoticeStrategy<Notice4618Request> {
  @Autowired(required = false)
  private List<Notice4618Listener> notice4618Listeners;

  @Override
  public String getCode() {
    return CpcnNoticeType.NOTICE_4618.getCode();
  }

  @Override
  public Notice4618Request exchange(NoticeRequest request) throws Exception {
    return new Notice4618Request(request.getDocument());
  }

  @Override
  public void handler(NoticeRequest request) {
    try {
      Notice4618Request notice4618Request = exchange(request);
      // 事件通知
      if (!CollectionUtils.isEmpty(notice4618Listeners)) {
        for (Notice4618Listener listener : notice4618Listeners) {
          listener.onNotice(notice4618Request);
        }
      }
    } catch (Exception e) {
      log.error("开户/绑卡结果通知出现错误", e);
      throw new RuntimeException(e.getLocalizedMessage());
    }
  }
}
