package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.gatheringaccredit;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;

/**
 * 2735-商户进件状态查询 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx2735Response extends TxBaseResponse {
  /**
   * 进件状态
   *
   * 20 - 受理成功
   * 30 - 正反扫权限已获取，其他待处理
   * 40 - 全部权限已获取
   * 50 - 失败
   */
  private String status;
  /**
   * 商户号授权状态:(在接口进件支付方式为微信 时返回)
   * 10=未授权
   * 20=已授权
   */
  private String authStatus;
  /**
   * 响应代码
   */
  private String responseCode;
  /**
   * 响应消息
   */
  private String responseMessage;
  /**
   * 响应时间 格式:yyyyMMddhh24mmss
   */
  private String responseTime;
  /**
   * 用户 ID
   */
  private String userID;
  /**
   * 商户号
   */
  private String merchantID;

  public Tx2735Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.status = XmlUtils.getNodeText(document, "Status");
      this.authStatus = XmlUtils.getNodeText(document, "AuthStatus");
      this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
      this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
      this.responseTime = XmlUtils.getNodeText(document, "ResponseTime");
      this.userID = XmlUtils.getNodeText(document, "UserID");
      this.merchantID = XmlUtils.getNodeText(document, "MerchantID");
    }
  }
}
