package com.biz.crm.common.pay.support.cpcn.base.common.security;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.Aes128Utils;
import com.biz.crm.common.pay.support.cpcn.base.common.utils.PayUtils;

import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

/**
 * 国密证书验证方法
 *
 * @author Keller
 */
public class CertificateVerifier implements Verifier {

  private PublicKey publicKey;

  private String algorithm = "SHA1withRSA";

  private X509Certificate x509Certificate;

  public CertificateVerifier(String file) throws Exception {
    FileInputStream fis = new FileInputStream(file);
    CertificateFactory cf = CertificateFactory.getInstance("X.509");
    this.x509Certificate = (X509Certificate)cf.generateCertificate(fis);
    this.publicKey = this.x509Certificate.getPublicKey();
  }

  public CertificateVerifier(String file, String algorithm) throws Exception {
    FileInputStream fis = new FileInputStream(file);
    CertificateFactory cf = CertificateFactory.getInstance("X.509");
    this.x509Certificate = (X509Certificate)cf.generateCertificate(fis);
    this.publicKey = this.x509Certificate.getPublicKey();
    this.algorithm = algorithm;
  }

  @Override
  public boolean verify(String message, String signature) throws Exception {
    byte[] bytes = PayUtils.hex2bytes(signature);
    Signature sig = Signature.getInstance(this.algorithm);
    sig.initVerify(this.publicKey);
    sig.update(message.getBytes(StandardCharsets.UTF_8));
    return sig.verify(bytes);
  }

  @Override
  public boolean verify(byte[] data, byte[] signature) throws Exception {
    Signature sig = Signature.getInstance(this.algorithm);
    sig.initVerify(this.publicKey);
    sig.update(data);
    return sig.verify(signature);
  }

  @Override
  public String symmetricEncrypt(String message, String symmetricCipher) throws Exception {
    return Aes128Utils.encrypt(message, symmetricCipher);
  }

  @Override
  public String asymmetricEncrypt(byte[] message) throws Exception {
    return PayUtils.encryptByRSA(message, this.publicKey);
  }

  @Override
  public String getSN() {
    byte[] snData = this.x509Certificate.getSerialNumber().toByteArray();
    if (snData == null) {
      return "";
    }
    int length = snData.length;
    StringBuffer buf = new StringBuffer();
    for (int i = 0; i != length; i++) {
      int v = snData[i] & 0xFF;
      buf.append("0123456789ABCDEF".charAt(v >>> 4));
      buf.append("0123456789ABCDEF".charAt(v & 0xF));
    }
    return String.valueOf(buf.toString());
  }

  public String getAlgorithm() {
    return this.algorithm;
  }

  public void setAlgorithm(String algorithm) {
    this.algorithm = algorithm;
  }

  public PublicKey getPublicKey() {
    return this.publicKey;
  }
}
