package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 4698-电子回单下载
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx4698Request extends TxBaseRequest {
  /**
   * 流水号
   */
  private String txSN;
  /**
   * 业务类型: 10=充值 20=提现 30=转账 40=支付 41=分账
   */
  private String businessType;
  /**
   * 原 业务流水号
   */
  private String sourceTxSN;

  /**
   * 分账业务流水号 businessType为41时 必填
   */
  private String sourceSplitTxSN;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element Body = document.createElement("Body");
    Element TxCode = document.createElement("TxCode");
    Element TxSN = document.createElement("TxSN");
    Element InstitutionID = document.createElement("InstitutionID");
    Element BusinessType = document.createElement("BusinessType");
    Element SourceTxSN = document.createElement("SourceTxSN");
    Element SourceSplitTxSN = document.createElement("SourceSplitTxSN");
    document.appendChild(Request);
    Request.setAttribute("version", "2.1");
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(TxSN);
    TxSN.setTextContent(this.txSN);
    Body.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Body.appendChild(BusinessType);
    BusinessType.setTextContent(this.businessType);
    Body.appendChild(SourceTxSN);
    SourceTxSN.setTextContent(this.sourceTxSN);
    Body.appendChild(SourceSplitTxSN);
    SourceSplitTxSN.setTextContent(this.sourceSplitTxSN);
    postProcess(document);
  }
}
