package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.AbstractTxStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate.Tx5016Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate.Tx5016Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 5016-支付查询
 *
 * <pre>
 *     机构系统通过该接口可以对5011-支付(API)和 5012-支付(页面)交易进行查询，
 *     支付平台返回该笔支付交易的支付状态、支付方式、支付成功时间等信息。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx5016Strategy extends AbstractTxStrategy<Tx5016Request, Tx5016Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_5016_REQUEST.getCode();
  }

  @Override
  public Class<Tx5016Response> getResponse() {
    return Tx5016Response.class;
  }
}
