package com.biz.crm.common.pay.support.cpcn.model;

import lombok.Data;

/**
 * 5011-支付（API） 请求的公共域
 *
 * @author hefan
 * @date 2022/08/25
 */
@Data
public class Tx5011TransferModel {
  /**
   * 交易流水号
   *
   * 格式:只能为数字字 母 开头和结尾, 中间 可以包含 -
   */
  private String txSN;

  /**
   * 业务订单号
   */
  private String orderNo;

  /**
   * 付款用户 ID
   */
  private String payerUserID;
  /**
   * 收款用户帐号
   */
  private String payeeAccountNumber;
  /**
   * 收款用户 ID
   */
  private String payeeUserID;
  /**
   * 支付方式:
   *
   * 00=余额支付
   * 02=信用支付
   * 10=快捷支付
   * 20=网银支付
   * 30=代收支付
   * 40=聚合支付(停止 接入新商户)
   * 42=条码支付
   * 43-扫码预授权
   * 50=O2O
   * 60=POS(暂不支 持)
   * 80-跳转支付
   */
  private String paymentWay;
  /**
   * 支付金额
   *
   * 单位:分,
   * - PaymentWay=42,ScanPaymentType=40 时,金额可为 0
   */
  private String amount;
  /**
   * 交易失效时间
   *
   * 目前仅支持聚合支付，扫码支付默认为24小时(24*60分钟)，最长30天，单位:分钟
   * 跳转支付默认为10分钟，有效范围:5-120分钟，单位:分钟
   * O2O支付,格式 1-30, 默认30天,单位:天;
   * 1c 为当天(仅支持PaymentWay=50-O2O)；
   * m 为分钟、h 为小时、d 为天、1c 为当天。
   * 例如：15m、12h、3d。
   */
  private String expirePeriod;
  /**
   * 回调 URL 地址
   * - 目前适用于网银支付和点金计划
   */
  private String pageURL;
  /**
   * 是否有后续分账:
   *
   * 1-否
   * 2-是
   *
   * 默认为否
   */
  private String hasSubsequentSplit = "1";
  /**
   * 后台通知地址
   *
   * 注:商户上传以这个地址为准，商户未上传以机构配置后台通知为准
   */
  private String noticeURL;
  /**
   * 备注
   *
   * Payment=30 且是对公支付业务时,必传
   */
  private String remark;

}
