package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;

/**
 * 5011-支付(API) 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx5011Response extends TxBaseResponse {
  /**
   * 机构编号
   */
  private String institutionID;
  /**
   * 统一订单号
   */
  private String orderNo;
  /**
   * 支付流水号
   */
  private String txSN;
  /**
   * 支付金额，单位:分
   */
  private String amount;
  /**
   * 可用分账金额，单位:分
   */
  private String availableSplitAmount;
  /**
   * 支付状态:
   *
   * 10=未支付
   * 20=支付处理中
   * 30=支付成功
   * 40=支付失败
   * 50=订单关闭
   */
  private String status;
  /**
   * 用信申请 URL
   *
   * PaymentWay=02,且 Status=20 时非空，为信用支付用信申请 H5 地址
   */
  private String creditPayURL;
  /**
   * 收款用户手续费总 金额,单位:分
   */
  private String payeeUserFee;
  /**
   * 付款人手续费总金 额,单位:分
   */
  private String payerUserFee;
  /**
   * 支付 URL
   *
   * PaymentWay=20,且 Status=20 时非空， 为网银跳转地址;
   */
  private String eBankPayURL;
  /**
   * 支付宝微信聚合码二维码
   *
   * PaymentWay=40,QR PaymentWay=41，且 Status=20 时非空 PaymentWay=42,Sca nPaymentway=41， 且 Status=20 时非空
   */
  private String qRCodeURL;
  /**
   * 支付宝微信聚合码二维码图片URL
   *
   * PaymentWay=40,QRPaymentWay=41,且Status=20 时非空
   * PaymentWay=42,ScanPaymentway=41,且Status=20 时非空
   */
  private String qRImageURL;
  /**
   * 授权码
   */
  private String qRAuthCode;
  /**
   * 付款用户 ID
   *
   * PaymentWay=40、42 和80时, 实际支付方式为微信支付时为微信的 openid; 实际支付方式为支付宝支付时为支付宝的Buyer_user_id
   */
  private String payerID;
  /**
   * 实际支付方式为微信，支付时为微信的子商户 appid 下用户唯一标识
   */
  private String subOpenID;
  /**
   * 实际支付银行卡类型:
   *
   * 10=余额
   * 20=借记卡
   * 30=贷记卡
   * 40=其他
   */
  private String actualCardType;
  /**
   * 转账识别码
   *
   * PaymentWay=50,且 Status=20 时非空，为 O2O支付转账识别码;
   */
  private String udID;
  /**
   * 失效时间
   */
  private String expireTime;
  /**
   * 平台订单号
   */
  @Deprecated
  private String traceNo;
  /**
   * 支付回单流水号
   */
  private String bankTraceNo;
  /**
   * 响应时间
   */
  private String responseTime;
  /**
   * 响应编码
   */
  private String responseCode;
  /**
   * 响应消息
   */
  private String responseMessage;

  public Tx5011Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.institutionID = XmlUtils.getNodeText(document, "InstitutionID");
      this.orderNo = XmlUtils.getNodeText(document, "OrderNo");
      this.txSN = XmlUtils.getNodeText(document, "TxSN");
      this.amount = XmlUtils.getNodeText(document, "Amount");
      this.availableSplitAmount = XmlUtils.getNodeText(document, "AvailableSplitAmount");
      this.status = XmlUtils.getNodeText(document, "Status");
      this.creditPayURL = XmlUtils.getNodeText(document, "CreditPayURL");
      this.payeeUserFee = XmlUtils.getNodeText(document, "PayeeUserFee");
      this.payerUserFee = XmlUtils.getNodeText(document, "PayerUserFee");
      this.eBankPayURL = XmlUtils.getNodeText(document, "EBankPayURL");
      this.qRCodeURL = XmlUtils.getNodeText(document, "QRCodeURL");
      this.qRImageURL = XmlUtils.getNodeText(document, "QRImageURL");
      this.qRAuthCode = XmlUtils.getNodeText(document, "QRAuthCode");
      this.payerID = XmlUtils.getNodeText(document, "PayerID");
      this.subOpenID = XmlUtils.getNodeText(document, "SubOpenID");
      this.actualCardType = XmlUtils.getNodeText(document, "ActualCardType");
      this.udID = XmlUtils.getNodeText(document, "UdID");
      this.expireTime = XmlUtils.getNodeText(document, "ExpireTime");
      this.traceNo = XmlUtils.getNodeText(document, "TraceNo");
      this.bankTraceNo = XmlUtils.getNodeText(document, "BankTraceNo");
      this.responseTime = XmlUtils.getNodeText(document, "ResponseTime");
      this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
      this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
    }
  }
}
