package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.enrollment;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.validation.constraints.NotBlank;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 7703-壹企付用户签约入网
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx7703Request extends TxBaseRequest {
  /**
   * 申请流水号
   */
  @NotBlank(message = "申请流水号不能为空")
  private String applyNo;
  /**
   * 用户ID
   *
   * 已开户的个体工商户或企业用户ID
   */
  @NotBlank(message = "用户ID不能为空")
  private String userID;
  /**
   * 协议模板编号
   *
   * MBOSS 系统为机构/商户维护,线下告知商户
   */
  @NotBlank(message = "协议模板编号不能为空")
  private String protocolNumber;
  /**
   * 协议签署人类型
   *
   * 10-企业法人(企 业) 20-经办人(企业) 30-个体工商户自 身(个体)
   * 会根据实际 UserID 查会员后 判断类型与本字段上传是否一 致
   */
  @NotBlank(message = "协议签署人类型不能为空")
  private String protocolSignerType;
  /**
   * 经办人手机号
   *
   * ProtocolSignerType=20时，必填
   */
  private String agentPhoneNumber;
  /**
   * 经办人姓名
   * ProtocolSignerType=20 时，必填
   */
  private String agentName;
  /**
   * 经办人身份证号
   *
   * ProtocolSignerType=20 时，必填
   */
  private String agentIDNumber;
  /**
   * 立即签约 10-是 20-否
   *
   * 10-是:给签署人下发短信验证 码，签署人在商户页面输入短 信验证码跳转到中金商户自助 入网系统进行签约
   * 20-否:签署人在中金商户自助 入网页面登录签约
   */
  private String immediatelySign;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element InstitutionID = document.createElement("InstitutionID");
    Element TxCode = document.createElement("TxCode");
    Element Body = document.createElement("Body");
    Element ApplyNo = document.createElement("ApplyNo");
    Element UserID = document.createElement("UserID");
    Element ProtocolNumber = document.createElement("ProtocolNumber");
    Element ProtocolSignerType = document.createElement("ProtocolSignerType");
    Element AgentPhoneNumber = document.createElement("AgentPhoneNumber");
    Element AgentName = document.createElement("AgentName");
    Element AgentIDNumber = document.createElement("AgentIDNumber");
    Element ImmediatelySign = document.createElement("ImmediatelySign");
    Request.setAttribute("version", "2.1");
    document.appendChild(Request);
    Request.appendChild(Head);
    Head.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(ApplyNo);
    ApplyNo.setTextContent(this.applyNo);
    Body.appendChild(UserID);
    UserID.setTextContent(this.userID);
    Body.appendChild(ProtocolNumber);
    ProtocolNumber.setTextContent(this.protocolNumber);
    Body.appendChild(ProtocolSignerType);
    ProtocolSignerType.setTextContent(this.protocolSignerType);
    Body.appendChild(AgentPhoneNumber);
    AgentPhoneNumber.setTextContent(this.agentPhoneNumber);
    Body.appendChild(AgentName);
    AgentName.setTextContent(this.agentName);
    Body.appendChild(AgentIDNumber);
    AgentIDNumber.setTextContent(this.agentIDNumber);
    Body.appendChild(ImmediatelySign);
    ImmediatelySign.setTextContent(this.immediatelySign);
    postProcess(document);
  }
}
