package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.gatheringaccredit;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;

/**
 * 2751-卡 bin 信息查询 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx2751Response extends TxBaseResponse {
  /**
   * 机构编号
   */
  private String institutionID;
  /**
   * 交易流水
   */
  private String txSN;
  /**
   * 查询结果:
   * 10=未知
   * 20=查询成功
   */
  private String status;
  /**
   * 卡介质类型:
   * 10=借记卡
   * 20=贷记卡
   */
  private String cardMediaType;
  /**
   * 发卡银行ID
   */
  private String bankID;
  /**
   * 发卡银行名称
   */
  private String bankName;

  public Tx2751Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.institutionID = XmlUtils.getNodeText(document, "InstitutionID");
      this.txSN = XmlUtils.getNodeText(document, "TxSN");
      this.status = XmlUtils.getNodeText(document, "Status");
      this.cardMediaType = XmlUtils.getNodeText(document, "CardMediaType");
      this.bankID = XmlUtils.getNodeText(document, "BankID");
      this.bankName = XmlUtils.getNodeText(document, "BankName");
    }
  }
}
