package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.statement;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 1850-对账文件下载
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx1850Request extends TxBaseRequest {
  /**
   * 对账日期 格式:YYYYMMDD
   */
  private String billDate;
  /**
   * 01-24,批次号可以不填,为空时下载该天的 对账文件如:20191213.zip
   */
  private String batchNO;
  /**
   * 收款用户 ID
   */
  private String payeeUserID;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element Body = document.createElement("Body");
    Element TxCode = document.createElement("TxCode");
    Element InstitutionID = document.createElement("InstitutionID");
    Element BillDate = document.createElement("BillDate");
    Element BatchNO = document.createElement("BatchNO");
    Element PayeeUserID = document.createElement("PayeeUserID");
    Request.setAttribute("version", "2.1");
    document.appendChild(Request);
    Request.appendChild(Head);
    Request.appendChild(Body);
    Head.appendChild(TxCode);
    Body.appendChild(InstitutionID);
    Body.appendChild(BillDate);
    Body.appendChild(BatchNO);
    Body.appendChild(PayeeUserID);
    TxCode.setTextContent(this.txCode);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    BillDate.setTextContent(this.billDate);
    BatchNO.setTextContent(this.batchNO);
    PayeeUserID.setTextContent(this.payeeUserID);
    postProcess(document);
  }
}
