/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.support.cpcn.service.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.TxService;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4665Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4665Response;
import com.biz.crm.common.pay.support.cpcn.util.SerialNumberUtils;
import com.biz.crm.common.pay.support.sdk.model.ResponseModel;
import com.biz.crm.common.pay.support.sdk.service.WhiteListSupportVoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WhiteListSupportVoServiceImpl
implements WhiteListSupportVoService {
    @Autowired(required=false)
    private TxService<Tx4665Response> tx4665Service;

    public ResponseModel create(String bankAccountName, String bankAccountNumber, String payeeMainUserID, String payeeUserID) {
        String whiteListType = "10";
        String operation = "10";
        Tx4665Request tx4665Request = this.getTx4665Request(whiteListType, operation, bankAccountName, bankAccountNumber, payeeMainUserID, payeeUserID);
        Tx4665Response response = this.tx4665Service.handlerTx(CpcnRequestType.TX_4665_REQUEST.getCode(), tx4665Request);
        return this.parse(response);
    }

    private ResponseModel parse(Tx4665Response response) {
        String code = response.getCode();
        boolean isSuccess = "2000".equals(code);
        ResponseModel responseModel = new ResponseModel();
        responseModel.setSuccess(Boolean.valueOf(isSuccess));
        if (!isSuccess) {
            responseModel.setMessage(response.getMessage());
            return responseModel;
        }
        responseModel.setMessage(response.getResponseMessage());
        String status = response.getStatus();
        isSuccess = "20".equals(status);
        if (isSuccess) {
            return responseModel;
        }
        boolean isDelay = "10".equals(status);
        responseModel.setDelay(Boolean.valueOf(isDelay));
        return responseModel;
    }

    private Tx4665Request getTx4665Request(String whiteListType, String operation, String bankAccountName, String bankAccountNumber, String payeeMainUserID, String payeeUserID) {
        Tx4665Request tx4665Request = new Tx4665Request();
        tx4665Request.setTxCode(CpcnRequestType.TX_4665_REQUEST.getCode());
        tx4665Request.setTxSN(SerialNumberUtils.create());
        tx4665Request.setWhiteListType(whiteListType);
        tx4665Request.setOperation(operation);
        tx4665Request.setBankAccountName(bankAccountName);
        tx4665Request.setBankAccountNumber(bankAccountNumber);
        tx4665Request.setPayeeMainUserID(payeeMainUserID);
        tx4665Request.setPayeeUserID(payeeUserID);
        return tx4665Request;
    }
}

