package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.AbstractTxStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate.Tx5011Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate.Tx5011Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 5011-支付(API)
 *
 * <pre>
 *     5011-支付(API)接口是一个综合性支付接口，
 *     支持余额支付、快捷支付、网银支付、代收、跳转支付、扫码支付、O2O 支付、信用支付等多样化的支付方式。
 *     当用户在机构系统发起支付请求时，机构系统通过该接口将支付请求发送到支付平台，支付平台收到请求后立即处理，
 *     并将处理结果实时返回给 机构系统。对于未返回支付终态(终态指支付成功、支付失败或订单关闭)的交易，
 *     机构系统可以通过 5016-支付查询接口或者5018-支付结果通知同步交易状态。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx5011Strategy extends AbstractTxStrategy<Tx5011Request, Tx5011Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_5011_REQUEST.getCode();
  }

  @Override
  public Class<Tx5011Response> getResponse() {
    return Tx5011Response.class;
  }
}
