package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;

/**
 * 4666-白名单开通/注销记录查询 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx4666Response extends TxBaseResponse {
  /**
   * 白名单状态:
   *
   * 20=启用
   * 30=失效
   */
  private String status;
  /**
   * 响应时间
   *
   * 格式:yyyyMMddHHmmssSSS
   */
  private String responseTime;
  /**
   * 响应代码
   */
  private String responseCode;
  /**
   * 响应消息
   */
  private String responseMessage;

  public Tx4666Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.status = XmlUtils.getNodeText(document, "Status");
      this.responseTime = XmlUtils.getNodeText(document, "ResponseTime");
      this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
      this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
    }
  }

}
