package com.biz.crm.common.pay.support.cpcn.strategy.transfer.convertor;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnBillTransactionStatus;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate.Tx5011Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate.Tx5011Response;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.vo.SplitItem;
import com.biz.crm.common.pay.support.cpcn.model.Tx5011RedirectPayModel;
import com.biz.crm.common.pay.support.cpcn.util.IPUtils;
import com.biz.crm.common.pay.support.sdk.dto.transfer.AppletPayDto;
import com.biz.crm.common.pay.support.sdk.model.ResponseModel;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.carrier.Redirect7Wechat7Applet;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.carrier.TransferCarrier;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.convertor.TransferConvertor;
import com.biz.crm.common.pay.support.sdk.vo.transfer.QRAuthCodeVo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 转账转换器
 * redirect - 跳转支付
 * wechat - 微信
 * applet - 小程序
 * 数字 7 - 因为&符号在7上面，代表and的意思
 *
 * @author hefan
 * @date 2022/08/27
 */
public class Redirect7Wechat7AppletConvertor implements TransferConvertor<Tx5011Request, Tx5011Response> {

  @Autowired(required = false)
  private CpcnConfig cpcnConfig;

  @Override
  public Boolean isConvertible(TransferCarrier carrier) {
    return carrier instanceof Redirect7Wechat7Applet;
  }

  @Override
  public Tx5011Request convert(TransferCarrier carrier) {
    Validate.isTrue(this.isConvertible(carrier), StringUtils.join("跳转支付", "转换器", "不可转换"));
    Redirect7Wechat7Applet carrierImpl = (Redirect7Wechat7Applet) carrier;
    // 载体全量数据
    AppletPayDto transferData = carrierImpl.getTransferData();
    // 设置中金参数匹配具体的转账行为
    Tx5011RedirectPayModel model = this.getRedirectPayModel(transferData);
    // 转换为中金base模块可识别的业务对象
    Tx5011Request tx5011Request = this.getTx5011Request(model);
    return tx5011Request;
  }

  /**
   * 5011-支付（API）
   * - 跳转支付&微信&小程序 需要的传参
   *
   * @param dto dto
   * @return {@link Tx5011RedirectPayModel}
   */
  private Tx5011RedirectPayModel getRedirectPayModel(AppletPayDto dto) {
    Tx5011RedirectPayModel model = new Tx5011RedirectPayModel();
    // 80=跳转支付
    model.setPaymentWay("80");
    // 31=微信
    model.setPayType("31");
    // 51=小程序
    model.setPayWay("51");
    model.setPlatformName(cpcnConfig.getPlatformName());
    model.setClientIP(IPUtils.getIp());
    model.setSubAppID(dto.getSubAppID());
    model.setSubOpenID(dto.getSubOpenID());
    model.setRedirectSource(dto.getRedirectSource());
    model.setGoodsName(dto.getGoodsName());
    model.setTxSN(dto.getTxSN());
    model.setOrderNo(dto.getOrderNo());
    model.setPayerUserID(dto.getPayerUserID());
    model.setPayeeAccountNumber(dto.getPayeeAccountNumber());
    model.setPayeeUserID(dto.getPayeeUserID());
    model.setAmount(dto.getAmount());
    model.setExpirePeriod(dto.getExpirePeriod());
    model.setPageURL(cpcnConfig.getNoticeUrl());
    model.setHasSubsequentSplit("2");
    model.setNoticeURL(cpcnConfig.getNoticeUrl());
    model.setRemark(dto.getRemark());
    return model;
  }

  /**
   * 跳转支付 的请求
   * - 按照中金文档，跳转支付 该做的传值校验都做了。
   * - 这是以paymentWay为维度转参
   *
   * @param model 跳转支付 的请求
   * @return {@link Tx5011Request}
   */
  private Tx5011Request getTx5011Request(Tx5011RedirectPayModel model) {
    Tx5011Request tx5011Request = new Tx5011Request();
    // R
    tx5011Request.setTxSN(model.getTxSN());
    // 付款userID：经销商的userID
    tx5011Request.setPayerUserID(model.getPayerUserID());
    // 收款userID：品牌商的userID
    tx5011Request.setPayeeUserID(model.getPayeeUserID());
    tx5011Request.setPaymentWay(model.getPaymentWay());
    tx5011Request.setAmount(model.getAmount());
    tx5011Request.setExpirePeriod(model.getExpirePeriod());
    tx5011Request.setPageURL(model.getPageURL());
    tx5011Request.setHasSubsequentSplit(model.getHasSubsequentSplit());
    // O
    tx5011Request.setOrderNo(model.getOrderNo());
    tx5011Request.setNoticeURL(model.getNoticeURL());
    tx5011Request.setRemark(model.getRemark());
    // C
    // 因为我们都是机构内转账，所以这里也要填
    tx5011Request.setPayeeAccountNumber(model.getPayeeAccountNumber());
    // 聚合支付（必填）商品名称
    tx5011Request.setGoodsName(model.getGoodsName());

    // 后续分账：没有时（HasSubsequentSplit=1）必填 ： SplitItems {
    if ("1".equals(model.getHasSubsequentSplit())) {
      List<SplitItem> splitItems = new ArrayList<>();
      // fixme: 需要的人去实现
      tx5011Request.setSplitItemsList(splitItems);
    }
    // }

    // O
    //tx5011Request.setTerminalUserID();
    //tx5011Request.setExtension();

    // C
    //tx5011Request.setSourceTxTime();
    tx5011Request.setPlatformName(model.getPlatformName());
    tx5011Request.setClientIP(model.getClientIP());
    //tx5011Request.setDeductionSettlementFlag();

    // 支付方式：跳转支付 ：RedirectPay {
    tx5011Request.setPayWay(model.getPayWay());
    tx5011Request.setPayType(model.getPayType());
    tx5011Request.setRedirectPayBankID(model.getRedirectPayBankID());
    tx5011Request.setLimitPay(model.getLimitPay());
    tx5011Request.setSubAppID(model.getSubAppID());
    tx5011Request.setSubOpenID(model.getSubOpenID());
    tx5011Request.setInstallmentType(model.getInstallmentType());
    tx5011Request.setFeeMode(model.getFeeMode());
    tx5011Request.setBankAccountNumber(model.getBankAccountNumber());
    tx5011Request.setMaskAccNo(model.getMaskAccNo());
    tx5011Request.setInstallmentForce(model.getInstallmentForce());
    tx5011Request.setPhoneNumber(model.getPhoneNumber());
    tx5011Request.setLoginState(model.getLoginState());
    tx5011Request.setNumberOfInstallments(model.getNumberOfInstallments());
    tx5011Request.setIdentityInfo(model.getIdentityInfo());
    tx5011Request.setRedirectSource(model.getRedirectSource());
    // }

    return tx5011Request;
  }

  @Override
  public ResponseModel<QRAuthCodeVo> parseResponse(Tx5011Response response) {
    String code = response.getCode();
    boolean isSuccess = Constants.SUCCESS_CODE.equals(code);
    if (!isSuccess) {
      throw new RuntimeException(response.getMessage());
    }
    ResponseModel responseModel = new ResponseModel();
    responseModel.setSuccess(true);
    String status = response.getStatus();
    responseModel.setMessage(response.getResponseMessage());
    boolean haveUrl = CpcnBillTransactionStatus.PROCESSING.getCode().equals(status);
    if (haveUrl) {
      String qrAuthCode = response.getQRAuthCode();
      QRAuthCodeVo QRCodeVo = new QRAuthCodeVo();
      responseModel.setResponse(QRCodeVo);
      QRCodeVo.setQRAuthCode(qrAuthCode);
    }
    return responseModel;
  }
}
