package com.biz.crm.common.pay.support.sdk.dto.transfer;

import lombok.Data;

/**
 * 客户充值 dto
 * - 状态要与具体支付平台无关
 *
 * @author hefan
 * @date 2022/08/25
 */
@Data
public class PayDto extends TransferDto {
  /**
   * 商品名称
   */
  private String goodsName;
  /**
   * 信用卡限制标识
   *
   *  true =信用卡可用
   *  false =信用卡不可用
   */
  private Boolean qRLimitPay = true;
  /**
   * 取消支付后的前台跳转页面
   *
   * 正扫时,填入有效持卡人取消支付后跳转到此页面，应更换支付流水号后再次唤起支付。
   * 【需要注意】对于同一笔支付流水系统无法进行处理。
   */
  private String cancelPayRedirectPageURL;
  /**
   * 页面跳转方式
   * 10=公众号
   * 20=小程序
   */
  private String qRPageUrlType = "10";
  /**
   * 成功前台跳转页面
   *
   * 正扫时,填入有效此页面只用作商家广告宣传等展示，商户后台应只在收到中金后台的支付成功回调通知后，
   * 才能做真正的支付成功通知处理。
   */
  private String redirectPageURL;
}
