package com.biz.crm.common.pay.support.sdk.event;

import com.biz.crm.common.pay.support.sdk.vo.transfer.notice.RechargeVo;

/**
 * 客户充值 监听器
 *
 * @author hefan
 * @date 2022/08/26
 */
public interface CustomerRechargeListener {
  /**
   * 未支付
   *
   * @param vo
   */
  void onUnpaid(RechargeVo vo);

  /**
   * 在处理
   *
   * @param vo
   */
  void onProcessing(RechargeVo vo);

  /**
   * 成功
   *
   * @param vo
   */
  void onSuccess(RechargeVo vo);

  /**
   * 在失败
   *
   * @param vo
   */
  void onFailure(RechargeVo vo);

  /**
   * 在关闭
   *
   * @param vo
   */
  void onClose(RechargeVo vo);
}
