package com.biz.crm.common.pay.support.sdk.model;

import lombok.Data;

/**
 * 响应模型
 *
 * @author hefan
 * @date 2022/08/11
 */
@Data
public class ResponseModel<T> {

  /**
   * 判断处理结果是否成功
   * - 默认异常，强制开发人员处理
   * - 接受了处理 并且 是预期的status
   * - delay 为 true，强制success为false
   */
  private Boolean success = false;

  /**
   * 消息
   * - 正常的
   * - 异常的
   */
  private String message;

  /**
   * 延迟
   * - 处理了
   * - 结果要自己查
   * - 结果要等通知
   * - 为null，即该接口不存在该属性判定。
   */
  private Boolean delay;

  /**
   * 响应的数据
   */
  private T response;

  /**
   * delay 为 true，强制success为false
   *
   * @return {@link Boolean}
   */
  public Boolean getSuccess() {
    if (Boolean.TRUE.equals(this.delay)) {
      return false;
    }
    return success;
  }

}
