package com.biz.crm.common.pay.support.sdk.strategy.transfer.convertor;

import com.biz.crm.common.pay.support.sdk.model.ResponseModel;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.carrier.TransferCarrier;

/**
 * 转账转换器
 *
 * @author hefan
 * @date 2022/08/25
 */
public interface TransferConvertor<T, R> {

  /**
   * 是可转换
   *
   * @param carrier 航空公司
   * @return {@link Boolean}
   */
  Boolean isConvertible(TransferCarrier carrier);

  /**
   * 转换
   *
   * @param carrier 载体
   * @return {@link T}
   */
  T convert(TransferCarrier carrier);

  /**
   * 解析响应
   *
   * @param response 响应
   * @return {@link ResponseModel}
   */
  ResponseModel parseResponse(R response);
}
