package com.biz.crm.common.pay.support.sdk.service;

import com.biz.crm.common.pay.support.sdk.model.ResponseModel;
import com.biz.crm.common.pay.support.sdk.vo.BankAccountSupportVo;

import java.util.Collection;

/**
 * 银行卡服务
 *
 * @author hefan
 * @date 2022/08/10
 */
public interface BankAccountSupportVoService {
  /**
   * 找到所有
   * 查询银行卡绑定情况
   *
   * @return {@link ResponseModel}<{@link Collection}<{@link BankAccountSupportVo}>>
   */
  Collection<BankAccountSupportVo> findAll(String mainUserID, String userID);

  /**
   * 找到银行账户号码
   * 根据银行账户号码查询
   *
   * @param bankAccountNumber 银行账户号码
   * @param mainUserID        主要用户id
   * @param userID            用户id
   * @return {@link BankAccountSupportVo}
   */
  BankAccountSupportVo findByBankAccountNumber(String bankAccountNumber, String mainUserID, String userID);
}
