package com.biz.crm.common.personalized.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.personalized.local.entity.PersonalizedFavorites;
import com.biz.crm.common.personalized.local.service.PersonalizedFavoritesService;
import com.biz.crm.common.personalized.sdk.dto.PersonalizedFavoritesDto;
import com.biz.crm.common.personalized.sdk.vo.PersonalizedFavoritesVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author XXLsansui
 * @date 2023-02-14 16:38
 * @description：个性化功能收藏夹
 */
@Slf4j
@RestController
@RequestMapping("/v1/personalizedFavorites/personalizedFavorites")
@Api(tags = "个性化功能收藏夹 : PersonalizedFavorites : 个性化功能收藏夹")
public class PersonalizedFavoritesController {

  @Autowired(required = false)
  private PersonalizedFavoritesService personalizedFavoritesService;

  /**
   * 根据当前登陆人查询收藏列表
   *
   * @return
   */
  @ApiOperation(value = "根据当前登陆人查询收藏列表")
  @GetMapping(value = {"/findFavoriteByAccount"})
  public Result<PersonalizedFavoritesVo> findFavoriteByAccount() {
    try {
      PersonalizedFavoritesVo result = this.personalizedFavoritesService.findFavoriteByAccount();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建及排序
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "创建及排序")
  @PostMapping(value = "")
  public Result<PersonalizedFavorites> create(@RequestBody PersonalizedFavoritesDto dto) {
    try {
      PersonalizedFavorites current = this.personalizedFavoritesService.create(dto);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "物理删除")
  @PostMapping("/delete")
  public Result delete(@RequestBody PersonalizedFavoritesDto dto) {
    try {
      this.personalizedFavoritesService.deleteBatch(dto);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
