package com.biz.crm.common.personalized.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.personalized.local.entity.ScreenButton;
import com.biz.crm.common.personalized.local.service.ScreenButtonService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author XXLsansui
 * @date 2023-02-13 14:49
 * @description：列表模板-常用筛选
 */
@Slf4j
@Api(tags = "列表模板-常用筛选")
@RestController
@RequestMapping(value = {"/v1/screenButton/screenButton"})
public class ScreenButtonController {
  @Autowired
  private ScreenButtonService screenButtonService;

  /**
   * 查询分页列表
   *
   * @param pageable 分页
   * @param screenButton 查询参数
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<ScreenButton>> findByConditions(@PageableDefault(50) Pageable pageable, ScreenButton screenButton) {
    try {
      Page<ScreenButton> result = this.screenButtonService.findByConditions(pageable, screenButton);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增
   */
  @ApiOperation(value = "新增")
  @PostMapping("")
  public Result<ScreenButton> create(@RequestBody ScreenButton screenButton) {
    return Result.ok(this.screenButtonService.create(screenButton));
  }


  /**
   * 更新
   */
  @ApiOperation(value = "更新")
  @PatchMapping("")
  public Result<ScreenButton> update(@RequestBody ScreenButton screenButton) {
    return Result.ok(this.screenButtonService.update(screenButton));
  }


  /**
   * 批量删除
   */
  @ApiOperation(value = "批量删除")
  @DeleteMapping("/deleteBatch")
  public Result delete(@RequestParam List<String> ids) {
    screenButtonService.deleteBatch(ids);
    return Result.ok("删除成功");
  }

}
