package com.biz.crm.common.personalized.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author XXLsansui
 * @date 2023-02-13 16:06
 * @description：
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("crm_screen_button")
@ApiModel(value = "ScreenButton", description = "常用筛选")
@Table(name = "crm_screen_button",
        indexes = {
                @Index(name = "crm_screen_button_idx1", columnList = "current_account", unique = false),
        })
@org.hibernate.annotations.Table(appliesTo = "crm_screen_button", comment = "常用筛选")
public class ScreenButton extends TenantFlagOpEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 当前用户
     */
    @ApiModelProperty("当前用户")
    @TableField(value = "current_account")
    @Column(name = "current_account", length = 64, columnDefinition = "VARCHAR2(64)")
    private String currentAccount;

    /**
     * 数据视图标识
     */
    @ApiModelProperty("数据视图标识")
    @TableField(value = "data_view")
    @Column(name = "data_view", length = 255, columnDefinition = "VARCHAR2(255)")
    private String dataView;

    /**
     * 是否默认
     */
    @ApiModelProperty("是否默认")
    @TableField(value = "is_default")
    private Boolean isDefault = false;

    /**
     * 常用筛选编码
     */
    @ApiModelProperty(value = "常用筛选编码")
    @TableField(value = "screen_button_code")
    @Column(name = "screen_button_code", length = 128, columnDefinition = "VARCHAR2(128)")
    private String screenButtonCode;

    /**
     * 常用筛选名称
     */
    @ApiModelProperty(value = "常用筛选名称")
    @TableField(value = "screen_button_name")
    @Column(name = "screen_button_name", length = 128, columnDefinition = "VARCHAR2(128)")
    private String screenButtonName;

    /**
     * 数据json
     */
    @ApiModelProperty(value = "数据json")
    @TableField(value = "data_json")
    @Column(name = "data_json", columnDefinition = "CLOB")
    private String dataJson;


}
