package com.biz.crm.common.personalized.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.personalized.local.entity.PersonalizedFavorites;
import com.biz.crm.common.personalized.local.repository.PersonalizedFavoritesRepository;
import com.biz.crm.common.personalized.local.service.PersonalizedFavoritesService;
import com.biz.crm.common.personalized.sdk.dto.PersonalizedFavoritesDto;
import com.biz.crm.common.personalized.sdk.vo.PersonalizedFavoritesVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author XXLsansui
 * @date 2023-02-14 16:40
 * @description：个性化功能收藏夹服务实现类
 */
@Service("personalizedFavoritesService")
public class PersonalizedFavoritesServiceImpl implements PersonalizedFavoritesService {

    @Autowired(required = false)
    private PersonalizedFavoritesRepository personalizedFavoritesRepository;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 分页查询
     *
     * @return
     */
    @Override
    public PersonalizedFavoritesVo findFavoriteByAccount() {
        //根据 租户 del_flag enable_status 当前用户 查询收藏列表
        PersonalizedFavorites paginationDto = new PersonalizedFavorites();
        paginationDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        paginationDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        paginationDto.setTenantCode(TenantUtils.getTenantCode());
        paginationDto.setCurrentAccount(loginUserService.getLoginAccountName());
        PersonalizedFavorites result = this.personalizedFavoritesRepository.findFavoriteByAccount(paginationDto);
        if (ObjectUtils.isEmpty(result)) {
            return null;
        }
        PersonalizedFavoritesVo vo = new PersonalizedFavoritesVo();
        vo.setCurrentAccount(result.getCurrentAccount());
        List<String> codes = Lists.newArrayList();
        if (StringUtils.isNotBlank(result.getCompetenceCodes())) {
            codes.addAll(Arrays.stream(result.getCompetenceCodes().split(",")).collect(Collectors.toList()));
        }
        vo.setCompetenceCodes(codes);
        return vo;
    }

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    @Override
    @Transactional
    public PersonalizedFavorites create(PersonalizedFavoritesDto dto) {
        Validate.notNull(dto, "收藏菜单信息缺失");
        Validate.isTrue(ObjectUtils.isNotEmpty(dto.getCompetenceCodes()), "收藏菜单编码不能为空");
        PersonalizedFavorites entity = new PersonalizedFavorites();
        String tenantCode = TenantUtils.getTenantCode();
        //当前登陆人
        String currentAccount = loginUserService.getLoginAccountName();
        entity.setTenantCode(tenantCode);
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setCurrentAccount(currentAccount);
        //字符串拼接
        String competenceCodes = String.join(",", dto.getCompetenceCodes());
        entity.setCompetenceCodes(competenceCodes);
        entity.setCreateName(currentAccount);
        entity.setCreateTime(new Date());

        //先删除旧的 再保存新的
        LambdaQueryWrapper<PersonalizedFavorites> lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper
                .eq(PersonalizedFavorites::getTenantCode, tenantCode)
                .eq(PersonalizedFavorites::getCurrentAccount, currentAccount);
        personalizedFavoritesRepository.remove(lambdaQueryWrapper);
        // 保存
        personalizedFavoritesRepository.saveOrUpdate(entity);
        //返回最终数据
        return entity;
    }

    /**
     * 物理删除
     * 传递一个待删除的菜单元素
     *
     * @param dto
     */
    @Override
    @Transactional
    public void deleteBatch(PersonalizedFavoritesDto dto) {
        Validate.notEmpty(dto.getCompetenceCodes(), "请选择删除的收藏菜单!");
        String tenantCode = TenantUtils.getTenantCode();
        String currentAccount = loginUserService.getLoginAccountName();
        PersonalizedFavorites entity = new PersonalizedFavorites();
        entity.setTenantCode(tenantCode);
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setCurrentAccount(currentAccount);
        //获取需要删除的菜单编码
        String code = dto.getCompetenceCodes().get(0);
        //找到当前用户数据
        entity = this.personalizedFavoritesRepository.findFavoriteByAccount(entity);
        List<String> list = Lists.newArrayList();
        if (StringUtils.isNotEmpty(entity.getCompetenceCodes())) {
            list.addAll(Arrays.stream(entity.getCompetenceCodes().split(",")).collect(Collectors.toList()));
        }
        //删除指定菜单编码
        list.removeIf(code::equals);
        String competenceCodes = String.join(",", list);
        entity.setCompetenceCodes(competenceCodes);
        entity.setModifyTime(new Date());
        entity.setModifyAccount(currentAccount);

        this.personalizedFavoritesRepository.saveOrUpdate(entity);

    }


}
