/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.personalized.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.personalized.local.entity.PersonalizedFavorites;
import com.biz.crm.common.personalized.local.service.PersonalizedFavoritesService;
import com.biz.crm.common.personalized.sdk.dto.PersonalizedFavoritesDto;
import com.biz.crm.common.personalized.sdk.vo.PersonalizedFavoritesVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/personalizedFavorites/personalizedFavorites"})
@Api(tags={"\u4e2a\u6027\u5316\u529f\u80fd\u6536\u85cf\u5939 : PersonalizedFavorites : \u4e2a\u6027\u5316\u529f\u80fd\u6536\u85cf\u5939"})
public class PersonalizedFavoritesController {
    private static final Logger log = LoggerFactory.getLogger(PersonalizedFavoritesController.class);
    @Autowired(required=false)
    private PersonalizedFavoritesService personalizedFavoritesService;

    @ApiOperation(value="\u6839\u636e\u5f53\u524d\u767b\u9646\u4eba\u67e5\u8be2\u6536\u85cf\u5217\u8868")
    @GetMapping(value={"/findFavoriteByAccount"})
    public Result<PersonalizedFavoritesVo> findFavoriteByAccount() {
        try {
            PersonalizedFavoritesVo result = this.personalizedFavoritesService.findFavoriteByAccount();
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa\u53ca\u6392\u5e8f")
    @PostMapping(value={""})
    public Result<PersonalizedFavorites> create(@RequestBody PersonalizedFavoritesDto dto) {
        try {
            PersonalizedFavorites current = this.personalizedFavoritesService.create(dto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7269\u7406\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result delete(@RequestBody PersonalizedFavoritesDto dto) {
        try {
            this.personalizedFavoritesService.deleteBatch(dto);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

