package com.biz.crm.common.personalized.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.personalized.local.entity.PersonalizedFavorites;
import com.biz.crm.common.personalized.local.mapper.PersonalizedFavoritesMapper;
import org.springframework.stereotype.Component;

/**
 * @author XXLsansui
 * @date 2023-02-14 16:42
 * @description：个性化收藏夹 Repository
 */
@Component
public class PersonalizedFavoritesRepository extends ServiceImpl<PersonalizedFavoritesMapper, PersonalizedFavorites> {

  /**
   * 查询当前用户的收藏菜单
   * @param dto
   * @return
   */
  public PersonalizedFavorites findFavoriteByAccount(PersonalizedFavorites dto) {
    PersonalizedFavorites one = this.lambdaQuery()
            .eq(PersonalizedFavorites::getTenantCode, dto.getTenantCode())
            .eq(PersonalizedFavorites::getDelFlag, dto.getDelFlag())
            .eq(PersonalizedFavorites::getEnableStatus, dto.getEnableStatus())
            .eq(PersonalizedFavorites::getCurrentAccount, dto.getCurrentAccount())
            .one();
    return one;
  }
}
