/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.personalized.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.personalized.local.entity.PersonalizedFavorites;
import com.biz.crm.common.personalized.local.repository.PersonalizedFavoritesRepository;
import com.biz.crm.common.personalized.local.service.PersonalizedFavoritesService;
import com.biz.crm.common.personalized.sdk.dto.PersonalizedFavoritesDto;
import com.biz.crm.common.personalized.sdk.vo.PersonalizedFavoritesVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="personalizedFavoritesService")
public class PersonalizedFavoritesServiceImpl
implements PersonalizedFavoritesService {
    @Autowired(required=false)
    private PersonalizedFavoritesRepository personalizedFavoritesRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    public PersonalizedFavoritesVo findFavoriteByAccount() {
        PersonalizedFavorites paginationDto = new PersonalizedFavorites();
        paginationDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        paginationDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        paginationDto.setTenantCode(TenantUtils.getTenantCode());
        paginationDto.setCurrentAccount(this.loginUserService.getLoginAccountName());
        PersonalizedFavorites result = this.personalizedFavoritesRepository.findFavoriteByAccount(paginationDto);
        if (ObjectUtils.isEmpty((Object)result)) {
            return null;
        }
        PersonalizedFavoritesVo vo = new PersonalizedFavoritesVo();
        vo.setCurrentAccount(result.getCurrentAccount());
        if (StringUtils.isNotEmpty((CharSequence)result.getCompetenceCodes())) {
            List codes = Arrays.stream(result.getCompetenceCodes().split(",")).collect(Collectors.toList());
            vo.setCompetenceCodes(codes);
        }
        return vo;
    }

    @Override
    @Transactional
    public PersonalizedFavorites create(PersonalizedFavoritesDto dto) {
        Validate.notNull((Object)dto, (String)"\u6536\u85cf\u83dc\u5355\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)dto.getCompetenceCodes()), (String)"\u6536\u85cf\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PersonalizedFavorites entity = new PersonalizedFavorites();
        String tenantCode = TenantUtils.getTenantCode();
        String currentAccount = this.loginUserService.getLoginAccountName();
        entity.setTenantCode(tenantCode);
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setCurrentAccount(currentAccount);
        String competenceCodes = String.join((CharSequence)",", dto.getCompetenceCodes());
        entity.setCompetenceCodes(competenceCodes);
        entity.setCreateName(currentAccount);
        entity.setCreateTime(new Date());
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(PersonalizedFavorites::getCurrentAccount, (Object)currentAccount);
        this.personalizedFavoritesRepository.remove((Wrapper)lambdaQueryWrapper);
        this.personalizedFavoritesRepository.saveOrUpdate(entity);
        return entity;
    }

    @Override
    @Transactional
    public void deleteBatch(PersonalizedFavoritesDto dto) {
        Validate.isTrue((dto.getCompetenceCodes().size() > 0 ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u5220\u9664\u7684\u6536\u85cf\u83dc\u5355!", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        String currentAccount = this.loginUserService.getLoginAccountName();
        PersonalizedFavorites entity = new PersonalizedFavorites();
        entity.setTenantCode(tenantCode);
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setCurrentAccount(currentAccount);
        String code = (String)dto.getCompetenceCodes().get(0);
        entity = this.personalizedFavoritesRepository.findFavoriteByAccount(entity);
        List list = Arrays.stream(entity.getCompetenceCodes().split(",")).collect(Collectors.toList());
        list.removeIf(code::equals);
        String competenceCodes = String.join((CharSequence)",", list);
        entity.setCompetenceCodes(competenceCodes);
        entity.setModifyTime(new Date());
        entity.setModifyAccount(currentAccount);
        this.personalizedFavoritesRepository.saveOrUpdate(entity);
    }
}

